/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import java.util.ArrayList;
import org.spoofax.interpreter.core.Tools;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.StrategoInt;
import org.spoofax.terms.StrategoReal;
import org.spoofax.terms.StrategoString;
import org.spoofax.terms.attachments.ParentAttachment;

public class HelperFunctions {
    public static ArrayList<IStrategoTerm> collectLeafnodes(IStrategoTerm trm) {
        ArrayList<IStrategoTerm> leafnodes = new ArrayList<IStrategoTerm>();
        IStrategoTerm[] subterms = trm.getAllSubterms();
        if (subterms.length == 0) {
            leafnodes.add(trm);
        } else {
            int i = 0;
            while (i < subterms.length) {
                leafnodes.addAll(HelperFunctions.collectLeafnodes(subterms[i]));
                ++i;
            }
        }
        return leafnodes;
    }

    public static void setParentAttachments(IStrategoTerm trm) {
        IStrategoTerm[] subterms = trm.getAllSubterms();
        int i = 0;
        while (i < subterms.length) {
            ParentAttachment.putParent(subterms[i], trm, null);
            HelperFunctions.setParentAttachments(subterms[i]);
            ++i;
        }
    }

    public static boolean isPrimitiveType(IStrategoTerm trm) {
        if (trm == null) {
            return false;
        }
        return trm.getTermType() == 3 || trm.getTermType() == 4 || trm.getTermType() == 5;
    }

    public static boolean isPrimitiveWithSameValue(IStrategoTerm t1, IStrategoTerm t2) {
        return HelperFunctions.isIntWithSameValue(t1, t2) || HelperFunctions.isRealWithSameValue(t1, t2) || HelperFunctions.isSringWithSameValue(t1, t2);
    }

    public static boolean isIntWithSameValue(IStrategoTerm t1, IStrategoTerm t2) {
        return t1.getTermType() == 3 && t2.getTermType() == 3 && ((StrategoInt)t1).intValue() == ((StrategoInt)t2).intValue();
    }

    public static boolean isSringWithSameValue(IStrategoTerm t1, IStrategoTerm t2) {
        return t1.getTermType() == 5 && t2.getTermType() == 5 && ((StrategoString)t1).stringValue().equals(((StrategoString)t2).stringValue());
    }

    public static boolean isRealWithSameValue(IStrategoTerm t1, IStrategoTerm t2) {
        return t1.getTermType() == 4 && t2.getTermType() == 4 && ((StrategoReal)t1).realValue() == ((StrategoReal)t2).realValue();
    }

    public static boolean haveSameSignature(IStrategoTerm t1, IStrategoTerm t2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        if (t1.getTermType() == 1 && t2.getTermType() == 1) {
            boolean sameConstructorName = HelperFunctions.haveSameConstructorName(t1, t2);
            return sameConstructorName && t1.getSubtermCount() == t2.getSubtermCount();
        }
        if (Tools.isTermList(t1) && Tools.isTermList(t2)) {
            return true;
        }
        return Tools.isTermTuple(t1) && Tools.isTermTuple(t2);
    }

    static boolean haveSameConstructorName(IStrategoTerm t1, IStrategoTerm t2) {
        String cons1 = ((IStrategoAppl)t1).getConstructor().getName();
        String cons2 = ((IStrategoAppl)t2).getConstructor().getName();
        boolean sameConstructorName = cons1.equals(cons2);
        return sameConstructorName;
    }

    static boolean isPrimitiveWithDifferentValues(IStrategoTerm ln, IStrategoTerm lnPartner) {
        return lnPartner != null && ln != null && HelperFunctions.isPrimitiveType(ln) && HelperFunctions.isPrimitiveType(lnPartner) && !HelperFunctions.isPrimitiveWithSameValue(ln, lnPartner);
    }

    public static boolean isSameTermType(IStrategoTerm t1, IStrategoTerm t2) {
        return Tools.isTermAppl(t1) && Tools.isTermAppl(t2) || Tools.isTermInt(t1) && Tools.isTermInt(t2) || Tools.isTermList(t1) && Tools.isTermList(t2) || Tools.isTermReal(t1) && Tools.isTermReal(t2) || Tools.isTermString(t1) && Tools.isTermString(t2) || Tools.isTermTuple(t1) && Tools.isTermTuple(t2);
    }

    public static boolean haveTupleOrListType(IStrategoTerm trm1, IStrategoTerm trm2) {
        return Tools.isTermList(trm1) && Tools.isTermList(trm2) || Tools.isTermTuple(trm1) && Tools.isTermTuple(trm2);
    }
}

