/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImmutableCollection;
import org.metaborg.util.collection.Sets;

public abstract class MultiSet<E>
implements Iterable<E>,
Serializable {
    public static final long serialVersionUID = 1L;
    private static final Immutable EMPTY = new Immutable(Map.Immutable.of());

    protected abstract Map<E, Integer> elements();

    public boolean isEmpty() {
        return this.elements().isEmpty();
    }

    public int size() {
        return this.elements().values().stream().mapToInt(i -> i).sum();
    }

    public int count(E e) {
        return this.elements().getOrDefault(e, 0);
    }

    public boolean contains(Object e) {
        return this.elements().containsKey(e);
    }

    public boolean containsAll(Iterable<E> es) {
        for (E e : es) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<E, Integer>> entrySet() {
        return this.elements().entrySet();
    }

    public Set<E> elementSet() {
        return this.elements().keySet();
    }

    @Override
    public Iterator<E> iterator() {
        return new MultiSetIterator();
    }

    public Optional<Integer> compareTo(MultiSet<E> other) {
        Map<E, Integer> ours = this.elements();
        Map<E, Integer> theirs = other.elements();
        boolean oursMissing = false;
        boolean theirsMissing = false;
        boolean oursSmaller = false;
        boolean theirsSmaller = false;
        for (E e : Sets.union(ours.keySet(), theirs.keySet())) {
            Integer ourCount = ours.get(e);
            Integer theirCount = theirs.get(e);
            if (ourCount == null && theirCount == null) continue;
            if (ourCount == null) {
                if (theirsMissing) {
                    return Optional.empty();
                }
                oursMissing = true;
                continue;
            }
            if (theirCount == null) {
                if (oursMissing) {
                    return Optional.empty();
                }
                theirsMissing = true;
                continue;
            }
            int d = ourCount - theirCount;
            if (d < 0) {
                if (theirsSmaller) {
                    return Optional.empty();
                }
                oursSmaller = true;
                continue;
            }
            if (d <= 0) continue;
            if (oursSmaller) {
                return Optional.empty();
            }
            theirsSmaller = true;
        }
        if (oursMissing || oursSmaller) {
            return Optional.of(-1);
        }
        if (theirsMissing || theirsSmaller) {
            return Optional.of(1);
        }
        return Optional.of(0);
    }

    public String toString() {
        return this.elements().entrySet().stream().map(e -> e.getKey() + ": " + e.getValue()).collect(Collectors.joining(", ", "{", "}"));
    }

    public static class Immutable<E>
    extends MultiSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map.Immutable<E, Integer> elements;

        private Immutable(Map.Immutable<E, Integer> elements) {
            this.elements = elements;
        }

        public static <T> Immutable<T> copyOf(MultiSet<T> toCopy) {
            if (toCopy instanceof Immutable) {
                return (Immutable)toCopy;
            }
            Transient<T> b = Transient.of();
            b.addAll(toCopy);
            return b.freeze();
        }

        @Override
        protected io.usethesource.capsule.Map<E, Integer> elements() {
            return this.elements;
        }

        public Immutable<E> set(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            if (n > 0) {
                return new Immutable<E>(this.elements.__put(e, (Object)n));
            }
            return new Immutable<E>(this.elements.__remove(e));
        }

        public Immutable<E> add(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            Integer oldCount = (Integer)this.elements.getOrDefault(e, (Object)0);
            int newCount = oldCount + n;
            if (newCount > 0) {
                return new Immutable<E>(this.elements.__put(e, (Object)newCount));
            }
            return new Immutable<E>(this.elements.__remove(e));
        }

        public Immutable<E> addAll(Iterable<E> es) {
            Immutable<E> result = this;
            for (E e : es) {
                result = result.add(e, 1);
            }
            return result;
        }

        public Immutable<E> remove(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            Integer oldCount = (Integer)this.elements.getOrDefault(e, (Object)0);
            int newCount = Math.max(0, oldCount - n);
            if (newCount > 0) {
                return new Immutable<E>(this.elements.__put(e, (Object)newCount));
            }
            return new Immutable<E>(this.elements.__remove(e));
        }

        public Immutable<E> removeAll(E e) {
            return new Immutable<E>(this.elements.__remove(e));
        }

        public Immutable<E> remove(Iterable<E> es) {
            Immutable<E> result = this;
            for (E e : es) {
                result = result.remove(e, 1);
            }
            return result;
        }

        public <T> Immutable<T> filterMap(Function<E, Optional<T>> filter) {
            boolean changed = false;
            Map.Transient map = CapsuleUtil.transientMap();
            for (Map.Entry e : this.elements.entrySet()) {
                filter.apply(e.getKey()).ifPresent(t -> {
                    Object object = map.__put(t, (Object)((Integer)e.getValue()));
                });
            }
            return new Immutable<E>(map.freeze());
        }

        public Map.Immutable<E, Integer> asMap() {
            return this.elements;
        }

        public Transient<E> melt() {
            return new Transient(this.elements.asTransient());
        }

        public static <E> Immutable<E> of() {
            return EMPTY;
        }

        public static <E> Immutable<E> of(E e) {
            return Immutable.of(e, 1);
        }

        public static <E> Immutable<E> of(Iterable<E> es) {
            Transient<E> result = Transient.of();
            for (E e : es) {
                result.add(e);
            }
            return result.freeze();
        }

        public static <E> Immutable<E> of(E e, int n) {
            return new Immutable<E>(Map.Immutable.of(e, (Object)n));
        }

        public static <E> Immutable<E> union(Immutable<E> set1, Immutable<E> set2) {
            if (set1.isEmpty() && set2.isEmpty()) {
                return EMPTY;
            }
            if (set1.isEmpty()) {
                return set2;
            }
            if (set2.isEmpty()) {
                return set1;
            }
            return set1.addAll(set2);
        }

        public Collection<E> toCollection() {
            return new ImmutableCollection<E>(){

                @Override
                public Iterator iterator() {
                    return this.iterator();
                }

                @Override
                public int size() {
                    return this.size();
                }
            };
        }
    }

    private class MultiSetIterator
    implements Iterator<E> {
        private Iterator<Map.Entry<E, Integer>> it;
        private E next;
        private int count;

        private MultiSetIterator() {
            this.it = MultiSet.this.elements().entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.count > 0 || this.it.hasNext();
        }

        @Override
        public E next() {
            if (this.next == null || this.count <= 0) {
                Map.Entry entry = this.it.next();
                this.next = entry.getKey();
                this.count = entry.getValue();
            }
            --this.count;
            return this.next;
        }
    }

    public static class Mutable<E>
    extends MultiSet<E> {
        private Map<E, Integer> elements;

        private Mutable(Map.Transient<E, Integer> elements) {
            this.elements = elements;
        }

        public Mutable() {
            this.elements = new HashMap<E, Integer>();
        }

        @Override
        protected Map<E, Integer> elements() {
            return this.elements;
        }

        public int set(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            Integer oldCount = n > 0 ? this.elements.put(e, n) : this.elements.remove(e);
            return oldCount != null ? oldCount : 0;
        }

        public int add(E e) {
            return this.add(e, 1);
        }

        public int add(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int oldCount = this.elements.getOrDefault(e, 0);
            int newCount = oldCount + n;
            if (newCount > 0) {
                this.elements.put(e, newCount);
            } else {
                this.elements.remove(e);
            }
            return oldCount;
        }

        public void addAll(Iterable<E> es) {
            for (E e : es) {
                this.add(e);
            }
        }

        public int remove(E e) {
            return this.remove(e, 1);
        }

        public void removeAll(Iterable<E> es) {
            if (es instanceof MultiSet) {
                for (Map.Entry entry : ((MultiSet)es).entrySet()) {
                    this.remove(entry.getKey(), entry.getValue());
                }
            } else {
                for (E e : es) {
                    this.remove(e);
                }
            }
        }

        public int remove(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int oldCount = this.elements.getOrDefault(e, 0);
            int newCount = Math.max(0, oldCount - n);
            if (newCount > 0) {
                this.elements.put(e, newCount);
            } else {
                this.elements.remove(e);
            }
            return oldCount;
        }

        public int removeAll(E e) {
            int oldCount = this.elements.getOrDefault(e, 0);
            this.elements.remove(e);
            return oldCount;
        }

        public void clear() {
            this.elements.clear();
        }
    }

    public static class Transient<E>
    extends MultiSet<E> {
        private Map.Transient<E, Integer> elements;

        private Transient(Map.Transient<E, Integer> elements) {
            this.elements = elements;
        }

        @Override
        protected io.usethesource.capsule.Map<E, Integer> elements() {
            return this.elements;
        }

        public int set(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            Integer oldCount = n > 0 ? (Integer)this.elements.__put(e, (Object)n) : (Integer)this.elements.__remove(e);
            return oldCount != null ? oldCount : 0;
        }

        public int add(E e) {
            return this.add(e, 1);
        }

        public int add(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int oldCount = (Integer)this.elements.getOrDefault(e, (Object)0);
            int newCount = oldCount + n;
            if (newCount > 0) {
                this.elements.__put(e, (Object)newCount);
            } else {
                this.elements.__remove(e);
            }
            return oldCount;
        }

        public void addAll(Iterable<E> es) {
            for (E e : es) {
                this.add(e);
            }
        }

        public int remove(E e) {
            return this.remove(e, 1);
        }

        public void removeAll(Iterable<E> es) {
            if (es instanceof MultiSet) {
                for (Map.Entry entry : ((MultiSet)es).entrySet()) {
                    this.remove(entry.getKey(), entry.getValue());
                }
            } else {
                for (E e : es) {
                    this.remove(e);
                }
            }
        }

        public int remove(E e, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            int oldCount = (Integer)this.elements.getOrDefault(e, (Object)0);
            int newCount = Math.max(0, oldCount - n);
            if (newCount > 0) {
                this.elements.__put(e, (Object)newCount);
            } else {
                this.elements.__remove(e);
            }
            return oldCount;
        }

        public int removeAll(E e) {
            int oldCount = (Integer)this.elements.getOrDefault(e, (Object)0);
            this.elements.__remove(e);
            return oldCount;
        }

        public Immutable<E> freeze() {
            return this.elements.isEmpty() ? EMPTY : new Immutable(this.elements.freeze());
        }

        public static <E> Transient<E> of() {
            return new Transient<E>(Map.Transient.of());
        }
    }
}

