/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.metaborg.util.collection.Multimap;

public abstract class LinkedMultimap<K, V, C extends Collection<V>>
extends Multimap<K, V, C> {
    protected final List<V> values;

    public LinkedMultimap() {
        this(new LinkedHashMap(), new ArrayList());
    }

    protected LinkedMultimap(Map<K, C> backingMap, List<V> values) {
        super(backingMap);
        this.values = values;
    }

    public LinkedMultimap(LinkedMultimap<K, V, C> toCopy) {
        this(toCopy.copyOfBackingMap(), new ArrayList<V>(toCopy.values));
    }

    @Override
    protected Map<K, C> copyOfBackingMap() {
        LinkedHashMap<Object, Collection> kcHashMap = new LinkedHashMap<Object, Collection>(this.backingMap);
        ((HashMap)kcHashMap).replaceAll((k, c) -> this.copyCollection(c));
        return kcHashMap;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsValue(V value) {
        return this.values.contains(value);
    }

    @Override
    public boolean put(K key, V value) {
        if (super.put(key, value)) {
            this.values.add(value);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
        this.values.clear();
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableList(this.values);
    }
}

