/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.outline;

import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.LinkedList;
import mb.util.vfs2.resource.ResourceUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.context.ContextException;
import org.metaborg.core.context.IContext;
import org.metaborg.core.context.IContextService;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.outline.IOutline;
import org.metaborg.core.outline.IOutlineNode;
import org.metaborg.core.outline.Outline;
import org.metaborg.core.outline.OutlineNode;
import org.metaborg.core.project.IProject;
import org.metaborg.core.project.IProjectService;
import org.metaborg.core.source.ISourceLocation;
import org.metaborg.core.source.ISourceRegion;
import org.metaborg.spoofax.core.dynamicclassloading.BuilderInput;
import org.metaborg.spoofax.core.outline.ISpoofaxOutlineService;
import org.metaborg.spoofax.core.outline.OutlineFacet;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.tracing.ISpoofaxTracingService;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class OutlineService
implements ISpoofaxOutlineService {
    private static final ILogger logger = LoggerUtils.logger(OutlineService.class);
    private final IProjectService projectService;
    private final IContextService contextService;
    private final IStrategoRuntimeService strategoRuntimeService;
    private final ISpoofaxTracingService tracingService;
    private final IStrategoCommon common;

    @Inject
    public OutlineService(IProjectService projectService, IContextService contextService, IStrategoRuntimeService strategoRuntimeService, ISpoofaxTracingService tracingService, IStrategoCommon common) {
        this.projectService = projectService;
        this.contextService = contextService;
        this.strategoRuntimeService = strategoRuntimeService;
        this.tracingService = tracingService;
        this.common = common;
    }

    @Override
    public boolean available(ILanguageImpl language) {
        return language.facet(OutlineFacet.class) != null;
    }

    @Override
    public IOutline outline(ISpoofaxParseUnit result) throws MetaborgException {
        IStrategoTerm outlineTerm;
        ILanguageComponent contributor;
        OutlineFacet facet;
        block8: {
            IContext context;
            if (!result.valid()) {
                return null;
            }
            FileObject source = result.source();
            IProject project = this.projectService.get(source);
            ILanguageImpl langImpl = result.input().langImpl();
            if (project == null) {
                context = null;
            } else {
                try {
                    context = this.contextService.get(source, project, langImpl);
                }
                catch (MetaborgRuntimeException | ContextException e) {
                    context = null;
                }
            }
            FacetContribution<OutlineFacet> facetContrib = this.facet(langImpl);
            facet = (OutlineFacet)facetContrib.facet;
            contributor = facetContrib.contributor;
            String strategy = facet.strategyName;
            try {
                HybridInterpreter interpreter = context == null ? this.strategoRuntimeService.runtime(contributor, source) : this.strategoRuntimeService.runtime(contributor, context);
                BuilderInput input = this.common.builderInputTerm(result.ast(), source, source);
                outlineTerm = this.common.invoke(interpreter, input, strategy);
                if (outlineTerm != null) break block8;
                return null;
            }
            catch (MetaborgException e) {
                throw new MetaborgException("Creating outline failed", e);
            }
        }
        IOutline outline = this.toOutline(outlineTerm, facet.expandTo, contributor.location());
        return outline;
    }

    @Override
    public IOutline outline(ISpoofaxAnalyzeUnit result) throws MetaborgException {
        IStrategoTerm outlineTerm;
        ILanguageComponent contributor;
        OutlineFacet facet;
        block4: {
            if (!result.valid() || !result.hasAst()) {
                return null;
            }
            FileObject source = result.source();
            IContext context = result.context();
            ILanguageImpl language = context.language();
            FacetContribution<OutlineFacet> facetContrib = this.facet(language);
            facet = (OutlineFacet)facetContrib.facet;
            contributor = facetContrib.contributor;
            String strategy = facet.strategyName;
            try {
                HybridInterpreter interpreter = this.strategoRuntimeService.runtime(contributor, context);
                BuilderInput input = this.common.builderInputTerm(result.ast(), source, context.location());
                outlineTerm = this.common.invoke(interpreter, input, strategy);
                if (outlineTerm != null) break block4;
                return null;
            }
            catch (MetaborgException e) {
                throw new MetaborgException("Creating outline failed", e);
            }
        }
        IOutline outline = this.toOutline(outlineTerm, facet.expandTo, contributor.location());
        return outline;
    }

    private FacetContribution<OutlineFacet> facet(ILanguageImpl language) throws MetaborgException {
        FacetContribution<OutlineFacet> facet = language.facetContribution(OutlineFacet.class);
        if (facet == null) {
            String message = logger.format("Cannot create outline for {}, it does not have an outline facet", language);
            throw new MetaborgException(message);
        }
        return facet;
    }

    @Nullable
    private IOutline toOutline(IStrategoTerm term, int expandTo, FileObject location) {
        LinkedList<IOutlineNode> roots = new LinkedList<IOutlineNode>();
        if (TermUtils.isList(term)) {
            IStrategoList termList = (IStrategoList)term;
            for (IStrategoTerm rootTerm : termList) {
                IOutlineNode node = this.toOutlineNode(rootTerm, null, location);
                if (node == null) continue;
                roots.add(node);
            }
        } else {
            IOutlineNode node = this.toOutlineNode(term, null, location);
            if (node != null) {
                roots.add(node);
            }
        }
        if (roots.isEmpty()) {
            return null;
        }
        return new Outline(roots, expandTo);
    }

    @Nullable
    private IOutlineNode toOutlineNode(IStrategoTerm term, @Nullable IOutlineNode parent, FileObject location) {
        if (!TermUtils.isAppl(term)) {
            return null;
        }
        IStrategoAppl appl = (IStrategoAppl)term;
        if (!TermUtils.isAppl(appl, "Node", 2)) {
            return null;
        }
        IStrategoTerm labelTerm = appl.getSubterm(0);
        String label = this.label(labelTerm);
        FileObject icon = this.icon(labelTerm, location);
        ISourceRegion region = this.region(labelTerm);
        OutlineNode node = new OutlineNode(label, icon, region, parent);
        IStrategoTerm nodesTerm = appl.getSubterm(1);
        for (IStrategoTerm nodeTerm : nodesTerm) {
            IOutlineNode childNode = this.toOutlineNode(nodeTerm, node, location);
            if (childNode == null) continue;
            node.addChild(childNode);
        }
        return node;
    }

    private String label(IStrategoTerm term) {
        if (TermUtils.isString(term)) {
            IStrategoString stringTerm = (IStrategoString)term;
            return stringTerm.stringValue();
        }
        return term.toString();
    }

    @Nullable
    private FileObject icon(IStrategoTerm term, FileObject location) {
        IStrategoList annos = term.getAnnotations();
        if (annos == null) {
            return null;
        }
        if (annos.getSubtermCount() != 1) {
            return null;
        }
        IStrategoTerm iconTerm = annos.getSubterm(0);
        if (!TermUtils.isString(iconTerm)) {
            return null;
        }
        IStrategoString iconTermString = (IStrategoString)iconTerm;
        String iconLocation = iconTermString.stringValue();
        try {
            return ResourceUtils.resolveFile(location, iconLocation);
        }
        catch (FileSystemException e) {
            logger.error("Cannot resolve icon {} in {}", e, iconLocation, location);
            return null;
        }
    }

    @Nullable
    private ISourceRegion region(IStrategoTerm term) {
        ISourceLocation location = this.tracingService.location(term);
        if (location != null) {
            return location.region();
        }
        return null;
    }
}

