/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.analysis.legacy;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.analysis.AnalysisException;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.Message;
import org.metaborg.core.messages.MessageFactory;
import org.metaborg.core.messages.MessageSeverity;
import org.metaborg.spoofax.core.analysis.AnalysisCommon;
import org.metaborg.spoofax.core.analysis.AnalysisFacet;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.analysis.ISpoofaxAnalyzer;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResult;
import org.metaborg.spoofax.core.analysis.SpoofaxAnalyzeResults;
import org.metaborg.spoofax.core.stratego.IStrategoCommon;
import org.metaborg.spoofax.core.stratego.IStrategoRuntimeService;
import org.metaborg.spoofax.core.unit.AnalyzeContrib;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxParseUnit;
import org.metaborg.spoofax.core.unit.ISpoofaxUnitService;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.time.Timer;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class StrategoAnalyzer
implements ISpoofaxAnalyzer {
    public static final String name = "stratego";
    private static final ILogger logger = LoggerUtils.logger(StrategoAnalyzer.class);
    private final ISpoofaxUnitService unitService;
    private final ITermFactory termFactory;
    private final IStrategoRuntimeService runtimeService;
    private final IStrategoCommon strategoCommon;
    private final AnalysisCommon analysisCommon;

    @Inject
    public StrategoAnalyzer(ISpoofaxUnitService unitService, ITermFactory termFactory, IStrategoRuntimeService runtimeService, IStrategoCommon strategoCommon, AnalysisCommon analysisCommon) {
        this.unitService = unitService;
        this.termFactory = termFactory;
        this.runtimeService = runtimeService;
        this.strategoCommon = strategoCommon;
        this.analysisCommon = analysisCommon;
    }

    @Override
    public ISpoofaxAnalyzeResult analyze(ISpoofaxParseUnit input, IContext context, IProgress progress, ICancel cancel) throws AnalysisException, InterruptedException {
        HybridInterpreter runtime;
        cancel.throwIfCancelled();
        if (!input.valid()) {
            String message = logger.format("Parse input for {} is invalid, cannot analyze", input.source());
            throw new AnalysisException(context, message);
        }
        ILanguageImpl language = context.language();
        FacetContribution<AnalysisFacet> facetContribution = language.facetContribution(AnalysisFacet.class);
        if (facetContribution == null) {
            logger.debug("No analysis required for {}", language);
            ISpoofaxAnalyzeUnit emptyUnit = (ISpoofaxAnalyzeUnit)this.unitService.emptyAnalyzeUnit(input, context);
            return new SpoofaxAnalyzeResult(emptyUnit, context);
        }
        AnalysisFacet facet = (AnalysisFacet)facetContribution.facet;
        cancel.throwIfCancelled();
        try {
            runtime = this.runtimeService.runtime(facetContribution.contributor, context);
        }
        catch (MetaborgException e) {
            throw new AnalysisException(context, "Failed to get Stratego runtime", e);
        }
        cancel.throwIfCancelled();
        ISpoofaxAnalyzeUnit result = this.analyze(input, context, runtime, facet.strategyName, this.termFactory);
        return new SpoofaxAnalyzeResult(result, context);
    }

    @Override
    public ISpoofaxAnalyzeResults analyzeAll(Iterable<ISpoofaxParseUnit> inputs, IContext context, IProgress progress, ICancel cancel) throws AnalysisException, InterruptedException {
        HybridInterpreter runtime;
        cancel.throwIfCancelled();
        ILanguageImpl language = context.language();
        FacetContribution<AnalysisFacet> facetContribution = language.facetContribution(AnalysisFacet.class);
        if (facetContribution == null) {
            logger.debug("No analysis required for {}", language);
            return new SpoofaxAnalyzeResults(context);
        }
        AnalysisFacet facet = (AnalysisFacet)facetContribution.facet;
        cancel.throwIfCancelled();
        try {
            runtime = this.runtimeService.runtime(facetContribution.contributor, context);
        }
        catch (MetaborgException e) {
            throw new AnalysisException(context, "Failed to get Stratego runtime", e);
        }
        int size = Iterables2.size(inputs);
        progress.setWorkRemaining(size);
        ArrayList<ISpoofaxAnalyzeUnit> results = new ArrayList<ISpoofaxAnalyzeUnit>(size);
        for (ISpoofaxParseUnit input : inputs) {
            cancel.throwIfCancelled();
            if (!input.valid()) {
                logger.warn("Parse input for {} is invalid, cannot analyze", input.source());
                progress.work(1);
                continue;
            }
            ISpoofaxAnalyzeUnit result = this.analyze(input, context, runtime, facet.strategyName, this.termFactory);
            results.add(result);
            progress.work(1);
        }
        return new SpoofaxAnalyzeResults((Collection<ISpoofaxAnalyzeUnit>)results, context);
    }

    private ISpoofaxAnalyzeUnit analyze(ISpoofaxParseUnit input, IContext context, HybridInterpreter runtime, String strategy, ITermFactory termFactory) throws AnalysisException {
        FileObject source = input.source();
        IStrategoString contextPath = this.strategoCommon.locationTerm(context.location());
        IStrategoString resourcePath = this.strategoCommon.resourceTerm(source, context.location());
        IStrategoTuple inputTerm = termFactory.makeTuple(input.ast(), resourcePath, contextPath);
        try {
            logger.trace("Analysing {}", source);
            Timer timer = new Timer(true);
            IStrategoTerm resultTerm = this.strategoCommon.invoke(runtime, inputTerm, strategy);
            long duration = timer.stop();
            if (resultTerm == null) {
                logger.trace("Analysis for {} failed", source);
                return this.result(this.analysisCommon.analysisFailedMessage(runtime), input, context, null, duration);
            }
            if (!TermUtils.isTuple(resultTerm)) {
                logger.trace("Analysis for {} has unexpected result, not a tuple", source);
                String message = logger.format("Unexpected results from analysis {}", resultTerm);
                return this.result(message, input, context, null, duration);
            }
            if (resultTerm.getSubtermCount() == 4) {
                logger.trace("Analysis for {} done", source);
                return this.result(resultTerm, input, context, duration);
            }
            if (resultTerm.getSubtermCount() == 3) {
                logger.trace("Analysis for {} done", source);
                return this.resultNoAst(resultTerm, input, context, duration);
            }
            logger.trace("Analysis for {} has unexpected result; tuple with more than 4 or less than 2 elements", source);
            String message = logger.format("Unexpected results from analysis {}", resultTerm);
            return this.result(message, input, context, null, duration);
        }
        catch (MetaborgException e) {
            String message = logger.format("Analysis for {} failed", source);
            logger.trace(message, e);
            throw new AnalysisException(context, message, e);
        }
    }

    private ISpoofaxAnalyzeUnit result(IStrategoTerm result, ISpoofaxParseUnit input, IContext context, long duration) {
        IStrategoTerm ast = result.getSubterm(0);
        FileObject source = input.source();
        Collection<IMessage> errors = this.analysisCommon.messages(source, MessageSeverity.ERROR, result.getSubterm(1));
        Collection<IMessage> warnings = this.analysisCommon.messages(source, MessageSeverity.WARNING, result.getSubterm(2));
        Collection<IMessage> notes = this.analysisCommon.messages(source, MessageSeverity.NOTE, result.getSubterm(3));
        Collection<IMessage> ambiguities = this.analysisCommon.ambiguityMessages(source, ast);
        ArrayList<IMessage> messages = new ArrayList<IMessage>(errors.size() + warnings.size() + notes.size() + ambiguities.size());
        messages.addAll(errors);
        messages.addAll(warnings);
        messages.addAll(notes);
        messages.addAll(ambiguities);
        return this.unitService.analyzeUnit(input, new AnalyzeContrib(true, errors.isEmpty(), true, ast, messages, duration), context);
    }

    private ISpoofaxAnalyzeUnit resultNoAst(IStrategoTerm result, ISpoofaxParseUnit input, IContext context, long duration) {
        FileObject source = input.source();
        Collection<IMessage> errors = this.analysisCommon.messages(source, MessageSeverity.ERROR, result.getSubterm(0));
        Collection<IMessage> warnings = this.analysisCommon.messages(source, MessageSeverity.WARNING, result.getSubterm(1));
        Collection<IMessage> notes = this.analysisCommon.messages(source, MessageSeverity.NOTE, result.getSubterm(2));
        ArrayList<IMessage> messages = new ArrayList<IMessage>(errors.size() + warnings.size() + notes.size());
        messages.addAll(errors);
        messages.addAll(warnings);
        messages.addAll(notes);
        return this.unitService.analyzeUnit(input, new AnalyzeContrib(true, errors.isEmpty(), false, null, messages, duration), context);
    }

    private ISpoofaxAnalyzeUnit result(String error, ISpoofaxParseUnit input, IContext context, Throwable e, long duration) {
        FileObject source = input.source();
        Message message = MessageFactory.newAnalysisErrorAtTop(source, error, e);
        return this.unitService.analyzeUnit(input, new AnalyzeContrib(false, false, true, null, Iterables2.singleton(message), duration), context);
    }
}

