/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.grammar.AssociativityInfo;
import org.metaborg.sdf2table.grammar.IAttribute;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.ISymbol;
import org.metaborg.sdf2table.grammar.NormGrammar;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.io.ParseTableIO;
import org.metaborg.util.collection.BiMap2;
import org.metaborg.util.collection.SetMultimap;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class Production
implements IProduction,
Serializable {
    private static final long serialVersionUID = 5887433349870067696L;
    private final Symbol lhs;
    private final List<Symbol> rhs;
    private final int arity;
    private AssociativityInfo associativityInfo;
    private int leftRecursivePos = -1;
    private int rightRecursivePos = -1;

    protected Production(Symbol lhs, List<Symbol> rhs) {
        this.lhs = lhs;
        this.rhs = new ArrayList<Symbol>(rhs);
        this.arity = rhs.size();
    }

    protected Production(Symbol lhs, List<Symbol> rhs, int leftRecPos, int rightRecPos) {
        this.lhs = lhs;
        this.rhs = new ArrayList<Symbol>(rhs);
        this.arity = rhs.size();
        this.leftRecursivePos = leftRecPos;
        this.rightRecursivePos = rightRecPos;
    }

    @Override
    public ISymbol leftHand() {
        return this.lhs;
    }

    @Override
    public List<ISymbol> rightHand() {
        return this.rhs.stream().collect(Collectors.toList());
    }

    public Symbol getLhs() {
        return this.lhs;
    }

    public List<Symbol> getRhs() {
        return this.rhs;
    }

    public int rightRecursivePosition() {
        return this.rightRecursivePos;
    }

    public int leftRecursivePosition() {
        return this.leftRecursivePos;
    }

    protected void setRightRecursivePosition(int pos) {
        this.rightRecursivePos = pos;
    }

    protected void setLeftRecursivePosition(int pos) {
        this.leftRecursivePos = pos;
    }

    public AssociativityInfo getAssociativityInfo() {
        return this.associativityInfo;
    }

    public void putNonAssociativity(Production other) {
        if (this.associativityInfo == null) {
            this.associativityInfo = new AssociativityInfo();
        }
        this.associativityInfo.getNonAssocWith().add(other);
    }

    public void putNonNested(Production other) {
        if (this.associativityInfo == null) {
            this.associativityInfo = new AssociativityInfo();
        }
        this.associativityInfo.getNonNestedWith().add(other);
    }

    public String toString() {
        String prod = "";
        prod = String.valueOf(prod) + this.lhs.name();
        prod = String.valueOf(prod) + " -> ";
        for (ISymbol iSymbol : this.rhs) {
            prod = String.valueOf(prod) + iSymbol.name() + " ";
        }
        return prod;
    }

    public IStrategoTerm toAterm(SetMultimap<IProduction, IAttribute> prod_attrs, BiMap2<IProduction, Integer> productionLabels) {
        ITermFactory tf = ParseTableIO.getTermfactory();
        IStrategoList.Builder rhs_terms = tf.arrayListBuilder(this.rhs.size());
        for (ISymbol iSymbol : this.rhs) {
            rhs_terms.add(((Symbol)iSymbol).toAterm(tf));
        }
        Set set = (Set)prod_attrs.get(this);
        IStrategoList.Builder attrs_terms = tf.arrayListBuilder(set.size() + 1);
        for (IAttribute a : set) {
            attrs_terms.add(a.toAterm(tf));
        }
        if (this.associativityInfo != null) {
            attrs_terms.add(this.associativityInfo.toAterm(tf, productionLabels));
        }
        if (attrs_terms.isEmpty()) {
            return tf.makeAppl(tf.makeConstructor("prod", 3), tf.makeList(rhs_terms), this.lhs.toAterm(tf), tf.makeAppl(tf.makeConstructor("no-attrs", 0), new IStrategoTerm[0]));
        }
        return tf.makeAppl(tf.makeConstructor("prod", 3), tf.makeList(rhs_terms), this.lhs.toAterm(tf), tf.makeAppl(tf.makeConstructor("attrs", 1), tf.makeList(attrs_terms)));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lhs == null ? 0 : this.lhs.hashCode());
        result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Production other = (Production)obj;
        if (this.lhs == null ? other.lhs != null : !this.lhs.equals(other.lhs)) {
            return false;
        }
        return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
    }

    public void calculateRecursion(NormGrammar grammar) {
        int i = 0;
        while (i < this.rhs.size()) {
            if (grammar.getLeftRecursiveSymbolsMapping().containsEntry(this.lhs, this.rhs.get(i))) {
                this.leftRecursivePos = i;
                break;
            }
            if (!this.rhs.get(i).isNullable()) break;
            ++i;
        }
        i = this.rhs.size() - 1;
        while (i >= 0) {
            if (grammar.getRightRecursiveSymbolsMapping().containsEntry(this.lhs, this.rhs.get(i))) {
                this.rightRecursivePos = i;
                break;
            }
            if (!this.rhs.get(i).isNullable()) break;
            --i;
        }
    }

    public IStrategoTerm toSDF3Aterm(SetMultimap<IProduction, IAttribute> prod_attrs, Map<Set<Context>, Integer> ctx_vals, Integer ctx_val) {
        ITermFactory tf = ParseTableIO.getTermfactory();
        IStrategoList.Builder rhs_terms = tf.arrayListBuilder(this.rhs.size());
        for (ISymbol iSymbol : this.rhs) {
            rhs_terms.add(((Symbol)iSymbol).toSDF3Aterm(tf, ctx_vals, ctx_val));
        }
        Set set = (Set)prod_attrs.get(this);
        IStrategoList.Builder attrs_terms = tf.arrayListBuilder(set.size());
        for (IAttribute a : set) {
            attrs_terms.add(a.toSDF3Aterm(tf));
        }
        if (attrs_terms.isEmpty()) {
            return tf.makeAppl(tf.makeConstructor("SdfProduction", 3), this.lhs.toSDF3Aterm(tf, ctx_vals, ctx_val), tf.makeAppl(tf.makeConstructor("Rhs", 1), tf.makeList(rhs_terms)), tf.makeAppl(tf.makeConstructor("NoAttrs", 0), new IStrategoTerm[0]));
        }
        return tf.makeAppl(tf.makeConstructor("SdfProduction", 3), this.lhs.toSDF3Aterm(tf, ctx_vals, ctx_val), tf.makeAppl(tf.makeConstructor("Rhs", 1), tf.makeList(rhs_terms)), tf.makeAppl(tf.makeConstructor("Attrs", 1), tf.makeList(attrs_terms)));
    }

    @Override
    public int arity() {
        return this.arity;
    }
}

