/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.symbols;

import org.metaborg.parsetable.symbols.ILiteralSymbol;
import org.metaborg.parsetable.symbols.NonTerminalSymbol;
import org.metaborg.parsetable.symbols.SortCardinality;
import org.metaborg.parsetable.symbols.SyntaxContext;

public class LiteralSymbol
extends NonTerminalSymbol
implements ILiteralSymbol {
    private final String literal;

    public LiteralSymbol(SyntaxContext syntaxContext, SortCardinality cardinality, String literal) {
        super(syntaxContext, cardinality);
        this.literal = literal;
    }

    @Override
    public String literal() {
        return this.literal;
    }

    @Override
    public boolean isOperator() {
        char[] cArray = this.literal.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String descriptor() {
        return "\"" + this.literal + "\"";
    }
}

