/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.config.ILanguageComponentConfig;
import org.metaborg.core.config.ILanguageImplConfig;
import org.metaborg.core.config.LanguageImplConfig;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageImplInternal;
import org.metaborg.core.language.ILanguageInternal;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.util.iterators.Iterables2;

public class LanguageImplementation
implements ILanguageImpl,
ILanguageImplInternal {
    private final LanguageIdentifier id;
    private final ILanguageInternal belongsTo;
    private final Set<ILanguageComponent> components = new HashSet<ILanguageComponent>();

    public LanguageImplementation(LanguageIdentifier id, ILanguageInternal belongsTo) {
        this.id = id;
        this.belongsTo = belongsTo;
    }

    @Override
    public LanguageIdentifier id() {
        return this.id;
    }

    @Override
    public int sequenceId() {
        int max2 = Integer.MIN_VALUE;
        for (ILanguageComponent component : this.components) {
            max2 = Math.max(component.sequenceId(), max2);
        }
        return max2;
    }

    @Override
    public List<FileObject> locations() {
        LinkedList<FileObject> locations = new LinkedList<FileObject>();
        for (ILanguageComponent component : this.components) {
            locations.add(component.location());
        }
        return locations;
    }

    @Override
    public Set<ILanguageComponent> components() {
        return this.components;
    }

    @Override
    public ILanguage belongsTo() {
        return this.belongsTo;
    }

    @Override
    public ILanguageInternal belongsToInternal() {
        return this.belongsTo;
    }

    @Override
    public ILanguageImplConfig config() {
        ArrayList<ILanguageComponentConfig> configs = new ArrayList<ILanguageComponentConfig>(this.components.size());
        for (ILanguageComponent component : this.components) {
            configs.add(component.config());
        }
        return new LanguageImplConfig(configs);
    }

    @Override
    public boolean hasFacet(Class<? extends IFacet> type) {
        for (ILanguageComponent component : this.components) {
            if (!component.hasFacet(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends IFacet> Iterable<T> facets(Class<T> type) {
        LinkedList facets = new LinkedList();
        for (ILanguageComponent component : this.components) {
            Iterables2.addAll(facets, component.facets(type));
        }
        return facets;
    }

    @Override
    public <T extends IFacet> Iterable<FacetContribution<T>> facetContributions(Class<T> type) {
        LinkedList<FacetContribution<T>> contributions = new LinkedList<FacetContribution<T>>();
        for (ILanguageComponent component : this.components) {
            Iterables2.addAll(contributions, component.facetContributions(type));
        }
        return contributions;
    }

    @Override
    public <T extends IFacet> T facet(Class<T> type) {
        Iterable<T> facets = this.facets(type);
        int size = Iterables2.size(facets);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new MetaborgRuntimeException("Multiple facets of " + type + " found in language implementation " + this.id + ", while only a single facet is supported");
        }
        return (T)((IFacet)facets.iterator().next());
    }

    @Override
    public <T extends IFacet> FacetContribution<T> facetContribution(Class<T> type) {
        Iterable<FacetContribution<T>> facetContributions = this.facetContributions(type);
        int size = Iterables2.size(facetContributions);
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new MetaborgRuntimeException("Multiple facets of " + type + " found in language implementation " + this.id + ", while only a single facet is supported");
        }
        return facetContributions.iterator().next();
    }

    @Override
    public Iterable<IFacet> facets() {
        LinkedList<IFacet> facets = new LinkedList<IFacet>();
        for (ILanguageComponent component : this.components) {
            Iterables2.addAll(facets, component.facets());
        }
        return facets;
    }

    @Override
    public Iterable<FacetContribution<IFacet>> facetContributions() {
        LinkedList<FacetContribution<IFacet>> contributions = new LinkedList<FacetContribution<IFacet>>();
        for (ILanguageComponent component : this.components) {
            Iterables2.addAll(contributions, component.facetContributions());
        }
        return contributions;
    }

    @Override
    public boolean addComponent(ILanguageComponent component) {
        return this.components.add(component);
    }

    @Override
    public boolean removeComponent(ILanguageComponent component) {
        return this.components.remove(component);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageImplementation other = (LanguageImplementation)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return "language impl. " + this.id;
    }
}

