/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build;

import jakarta.annotation.Nullable;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class CommonPaths {
    static final ILogger logger = LoggerUtils.logger(CommonPaths.class);
    protected final FileObject root;

    public CommonPaths(FileObject root) {
        this.root = root;
    }

    public FileObject root() {
        return this.root;
    }

    public FileObject transDir() {
        return this.resolve(this.root(), "trans");
    }

    public FileObject srcGenDir() {
        return this.resolve(this.root(), "src-gen");
    }

    public FileObject targetDir() {
        return this.resolve(this.root(), "target");
    }

    public FileObject targetMetaborgDir() {
        return this.resolve(this.targetDir(), "metaborg");
    }

    public FileObject replicateDir() {
        return this.resolve(this.targetDir(), "replicate");
    }

    public FileObject mbComponentConfigFile() {
        return this.resolve(this.srcGenDir(), "metaborg.component.yaml");
    }

    @Nullable
    protected FileObject find(Iterable<FileObject> dirs, String relativePath) {
        FileObject file = null;
        for (FileObject dir : dirs) {
            try {
                FileObject candidate = dir.resolveFile(relativePath);
                if (!candidate.exists()) continue;
                if (file != null) {
                    throw new MetaborgRuntimeException("Found multiple candidates for " + relativePath);
                }
                file = candidate;
            }
            catch (FileSystemException e) {
                logger.warn("Error when trying to resolve {} in {}", e, relativePath, dir);
            }
        }
        return file;
    }

    protected FileObject resolve(FileObject dir, String relativePath) {
        try {
            return dir.resolveFile(relativePath);
        }
        catch (FileSystemException e) {
            throw new MetaborgRuntimeException(e);
        }
    }

    protected FileObject resolve(FileObject dir, String ... relativePaths) {
        FileObject file = dir;
        String[] stringArray = relativePaths;
        int n = relativePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            file = this.resolve(file, path);
            ++n2;
        }
        return file;
    }
}

