/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.Pattern;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.spec.ARule;
import mb.statix.spec.RuleName;
import org.metaborg.util.collection.ImList;

public final class Rule
extends ARule
implements Serializable {
    private final String name;
    private final RuleName label;
    private final ImList.Immutable<Pattern> params;
    private final IConstraint body;
    @Nullable
    private final ICompleteness.Immutable bodyCriticalEdges;
    private transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long PARAM_VARS_LAZY_INIT_BIT = 1L;
    private transient Set.Immutable<ITermVar> paramVars;
    private static final long ALWAYS_LAZY_INIT_BIT = 2L;
    private transient Optional<Boolean> always;
    private static final long serialVersionUID = 42L;

    private Rule(String name, RuleName label, ImList.Immutable<Pattern> params, IConstraint body) {
        this.name = Objects.requireNonNull(name, "name");
        this.label = Objects.requireNonNull(label, "label");
        this.params = Objects.requireNonNull(params, "params");
        this.body = Objects.requireNonNull(body, "body");
        this.bodyCriticalEdges = super.bodyCriticalEdges();
    }

    private Rule(Builder builder) {
        this.name = builder.name;
        this.label = builder.label;
        this.params = builder.params;
        this.body = builder.body;
        this.bodyCriticalEdges = builder.bodyCriticalEdgesIsSet() ? builder.bodyCriticalEdges : super.bodyCriticalEdges();
    }

    private Rule(String name, RuleName label, ImList.Immutable<Pattern> params, IConstraint body, @Nullable ICompleteness.Immutable bodyCriticalEdges) {
        this.name = name;
        this.label = label;
        this.params = params;
        this.body = body;
        this.bodyCriticalEdges = bodyCriticalEdges;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public RuleName label() {
        return this.label;
    }

    @Override
    public ImList.Immutable<Pattern> params() {
        return this.params;
    }

    @Override
    public IConstraint body() {
        return this.body;
    }

    @Override
    @Nullable
    public ICompleteness.Immutable bodyCriticalEdges() {
        return this.bodyCriticalEdges;
    }

    public final Rule withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new Rule(newValue, this.label, this.params, this.body, this.bodyCriticalEdges);
    }

    public final Rule withLabel(RuleName value) {
        if (this.label == value) {
            return this;
        }
        RuleName newValue = Objects.requireNonNull(value, "label");
        return new Rule(this.name, newValue, this.params, this.body, this.bodyCriticalEdges);
    }

    public final Rule withParams(ImList.Immutable<Pattern> value) {
        if (this.params == value) {
            return this;
        }
        ImList.Immutable<Pattern> newValue = Objects.requireNonNull(value, "params");
        return new Rule(this.name, this.label, newValue, this.body, this.bodyCriticalEdges);
    }

    public final Rule withBody(IConstraint value) {
        if (this.body == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "body");
        return new Rule(this.name, this.label, this.params, newValue, this.bodyCriticalEdges);
    }

    public final Rule withBodyCriticalEdges(@Nullable ICompleteness.Immutable value) {
        if (this.bodyCriticalEdges == value) {
            return this;
        }
        return new Rule(this.name, this.label, this.params, this.body, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Rule && this.equalTo(0, (Rule)another);
    }

    private boolean equalTo(int synthetic, Rule another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && this.label.equals(another.label) && this.params.equals(another.params) && this.body.equals(another.body) && Objects.equals(this.bodyCriticalEdges, another.bodyCriticalEdges);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.params.hashCode();
        h += (h << 5) + this.body.hashCode();
        h += (h << 5) + Objects.hashCode(this.bodyCriticalEdges);
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<ITermVar> paramVars() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Rule rule = this;
            synchronized (rule) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.paramVars = Objects.requireNonNull(super.paramVars(), "paramVars");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.paramVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Boolean> isAlways() throws InterruptedException {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Rule rule = this;
            synchronized (rule) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.always = Objects.requireNonNull(super.isAlways(), "always");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.always;
    }

    public static Rule of(String name, RuleName label, ImList.Immutable<Pattern> params, IConstraint body) {
        return new Rule(name, label, params, body);
    }

    public static Rule copyOf(ARule instance) {
        if (instance instanceof Rule) {
            return (Rule)instance;
        }
        return Rule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Rule(Builder builder, Rule rule) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_LABEL = 2L;
        private static final long INIT_BIT_PARAMS = 4L;
        private static final long INIT_BIT_BODY = 8L;
        private static final long OPT_BIT_BODY_CRITICAL_EDGES = 1L;
        private long initBits = 15L;
        private long optBits;
        private String name;
        private RuleName label;
        private ImList.Immutable<Pattern> params;
        private IConstraint body;
        private ICompleteness.Immutable bodyCriticalEdges;

        private Builder() {
        }

        public final Builder from(ARule instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.label(instance.label());
            this.params(instance.params());
            this.body(instance.body());
            ICompleteness.Immutable bodyCriticalEdgesValue = instance.bodyCriticalEdges();
            if (bodyCriticalEdgesValue != null) {
                this.bodyCriticalEdges(bodyCriticalEdgesValue);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder label(RuleName label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder params(ImList.Immutable<Pattern> params) {
            this.params = Objects.requireNonNull(params, "params");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder body(IConstraint body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder bodyCriticalEdges(@Nullable ICompleteness.Immutable bodyCriticalEdges) {
            this.bodyCriticalEdges = bodyCriticalEdges;
            this.optBits |= 1L;
            return this;
        }

        public Rule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Rule(this, null);
        }

        private boolean bodyCriticalEdgesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("params");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build Rule, some of required attributes are not set " + attributes;
        }
    }
}

