/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.Renaming;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.State;
import mb.statix.solver.tracer.EmptyTracer;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;

public class IndexedRuleApplication {
    private static final ILogger logger = LoggerUtils.logger(IndexedRuleApplication.class);
    private final Spec spec;
    private final List<Pattern> params;
    @Nullable
    private final IConstraint constraint;
    private final ITerm index;

    private IndexedRuleApplication(Spec spec, List<Pattern> params, @Nullable IConstraint constraint, ITerm index) {
        this.spec = spec;
        this.params = params;
        this.constraint = constraint;
        this.index = index;
    }

    private IndexedRuleApplication apply(IRenaming renaming) {
        List<Pattern> newParams = this.params.stream().map(p -> p.apply(renaming)).collect(Collectors.toList());
        IConstraint newConstraint = this.constraint == null ? null : this.constraint.apply(renaming);
        return new IndexedRuleApplication(this.spec, newParams, newConstraint, renaming.apply(this.index));
    }

    public ITerm lookupIndex(IState.Immutable state) throws Delay, InterruptedException {
        ITerm lookupIndex = state.unifier().findRecursive(this.index);
        if (!lookupIndex.isGround()) {
            throw Delay.ofVars(lookupIndex.getVars());
        }
        return lookupIndex;
    }

    public Optional<ITerm> applyIndex(ITerm ... args) throws Delay, InterruptedException {
        return this.applyIndex(Arrays.asList(args));
    }

    public Optional<ITerm> applyIndex(List<ITerm> args) throws Delay, InterruptedException {
        ITerm applyIndex;
        ISubstitution.Immutable subst = TermPattern.P.match(this.params, args).orElse(null);
        if (subst == null) {
            return Optional.empty();
        }
        if (this.constraint != null) {
            State state = State.of();
            NullDebugContext debug = new NullDebugContext();
            SolverResult<EmptyTracer.Empty> solveResult = Solver.solve(this.spec, state, this.constraint.apply(subst), debug, new NullCancel(), new NullProgress(), 1);
            try {
                if (!Solver.entailed((IState.Immutable)state, solveResult, (IDebugContext)debug)) {
                    return Optional.empty();
                }
            }
            catch (Delay d) {
                logger.warn("Unexpected delay when computing apply index.", d);
                return Optional.empty();
            }
        }
        if (!(applyIndex = subst.apply(this.index)).isGround()) {
            throw Delay.ofVars(applyIndex.getVars());
        }
        return Optional.of(applyIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.params.stream().map(Object::toString).collect(Collectors.joining(",", "", ""))).append(")");
        sb.append("[").append(this.index).append("]");
        if (this.constraint != null) {
            sb.append(" :- ").append(this.constraint);
        }
        sb.append(".");
        return sb.toString();
    }

    public static Optional<IndexedRuleApplication> of(Spec spec, Rule rule) throws Delay, InterruptedException {
        IndexedRuleApplication newRule;
        IState.Transient state = State.of().melt();
        Renaming.Builder _renaming = Renaming.builder();
        for (ITermVar freeVar : rule.freeVars()) {
            _renaming.put(freeVar, state.freshVar(freeVar));
        }
        Renaming renaming = _renaming.build();
        try {
            newRule = IndexedRuleApplication.of(state.freeze(), spec, rule.apply(renaming)).orElse(null);
            if (newRule == null) {
                return Optional.empty();
            }
        }
        catch (Delay d) {
            throw Delay.ofVars(d.vars().stream().map(renaming::rename).collect(Collectors.toList()));
        }
        return Optional.of(newRule.apply(renaming));
    }

    public static Optional<IndexedRuleApplication> of(IState.Immutable state, Spec spec, Rule rule) throws Delay, InterruptedException {
        IndexedRuleApplication ira;
        Set.Immutable<ITermVar> freeVars = rule.freeVars();
        IState.Transient _state = state.melt();
        ArrayList<ITermVar> args = new ArrayList<ITermVar>();
        for (Pattern param : rule.params()) {
            ITermVar v = _state.freshVar(TermBuild.B.newVar("", "arg"));
            args.add(v);
        }
        IState.Immutable newState = _state.freeze();
        ApplyResult applyResult = RuleUtil.apply(newState.unifier(), rule, args, null, ApplyMode.RELAXED, ApplyMode.Safety.SAFE, true).orElse(null);
        if (applyResult == null) {
            return Optional.empty();
        }
        IConstraint bodyAsConstraint = applyResult.body();
        SolverResult<EmptyTracer.Empty> solveResult = Solver.solve(spec, newState, bodyAsConstraint, new NullDebugContext(), new NullCancel(), new NullProgress(), 1);
        if (solveResult.hasErrors()) {
            return Optional.empty();
        }
        TreeSet indexVars = new TreeSet();
        ArrayList<Pattern> newParams = new ArrayList<Pattern>();
        HashSet<ITermVar> newParamVars = new HashSet<ITermVar>();
        for (ITermVar arg : args) {
            ITerm term = solveResult.state().unifier().findRecursive(arg);
            Set.Immutable<ITermVar> termVars = term.getVars();
            Pattern param = TermPattern.P.fromTerm(term);
            indexVars.addAll(termVars.__retainAll(freeVars));
            newParams.add(param);
            newParamVars.addAll((Collection<ITermVar>)termVars);
        }
        ITerm index = TermBuild.B.newTuple(indexVars);
        if (solveResult.delays().isEmpty()) {
            ira = new IndexedRuleApplication(spec, newParams, null, index);
        } else {
            IConstraint residualConstraint = solveResult.delayed();
            Set.Immutable newFreeVars = residualConstraint.freeVars().__removeAll(newParamVars);
            if (!newFreeVars.isEmpty()) {
                throw Delay.ofVars((Iterable<ITermVar>)newFreeVars);
            }
            ira = new IndexedRuleApplication(spec, newParams, residualConstraint, index);
        }
        return Optional.of(ira);
    }
}

