/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import mb.statix.constraints.CTellEdge;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.persistent.step.ACTellEdgeStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CTellEdgeStep
extends ACTellEdgeStep {
    private final CTellEdge constraint;
    private final StepResult result;
    @Nullable
    private final Scope source;
    @Nullable
    private final Scope target;
    private transient int hashCode;

    private CTellEdgeStep(CTellEdge constraint, StepResult result, @Nullable Scope source, @Nullable Scope target) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
        this.source = source;
        this.target = target;
    }

    private CTellEdgeStep(CTellEdgeStep original, CTellEdge constraint, StepResult result, @Nullable Scope source, @Nullable Scope target) {
        this.constraint = constraint;
        this.result = result;
        this.source = source;
        this.target = target;
    }

    @Override
    public CTellEdge constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    @Override
    @Nullable
    public Scope source() {
        return this.source;
    }

    @Override
    @Nullable
    public Scope target() {
        return this.target;
    }

    public final CTellEdgeStep withConstraint(CTellEdge value) {
        if (this.constraint == value) {
            return this;
        }
        CTellEdge newValue = Objects.requireNonNull(value, "constraint");
        return new CTellEdgeStep(this, newValue, this.result, this.source, this.target);
    }

    public final CTellEdgeStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CTellEdgeStep(this, this.constraint, newValue, this.source, this.target);
    }

    public final CTellEdgeStep withSource(@Nullable Scope value) {
        if (this.source == value) {
            return this;
        }
        return new CTellEdgeStep(this, this.constraint, this.result, value, this.target);
    }

    public final CTellEdgeStep withTarget(@Nullable Scope value) {
        if (this.target == value) {
            return this;
        }
        return new CTellEdgeStep(this, this.constraint, this.result, this.source, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CTellEdgeStep && this.equalTo(0, (CTellEdgeStep)another);
    }

    private boolean equalTo(int synthetic, CTellEdgeStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result) && Objects.equals(this.source, another.source) && Objects.equals(this.target, another.target);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + Objects.hashCode(this.source);
        h += (h << 5) + Objects.hashCode(this.target);
        return h;
    }

    public String toString() {
        return "CTellEdgeStep{constraint=" + this.constraint + ", result=" + this.result + ", source=" + this.source + ", target=" + this.target + "}";
    }

    public static CTellEdgeStep of(CTellEdge constraint, StepResult result, @Nullable Scope source, @Nullable Scope target) {
        return new CTellEdgeStep(constraint, result, source, target);
    }

    public static CTellEdgeStep copyOf(ACTellEdgeStep instance) {
        if (instance instanceof CTellEdgeStep) {
            return (CTellEdgeStep)instance;
        }
        return CTellEdgeStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CTellEdgeStep(CTellEdgeStep cTellEdgeStep, CTellEdge cTellEdge, StepResult stepResult, Scope scope, Scope scope2, CTellEdgeStep cTellEdgeStep2) {
        this(cTellEdgeStep, cTellEdge, stepResult, scope, scope2);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CTellEdge constraint;
        private StepResult result;
        private Scope source;
        private Scope target;

        private Builder() {
        }

        public final Builder from(ACTellEdgeStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACTellEdgeStep) {
                Scope targetValue;
                instance = (ACTellEdgeStep)object;
                this.constraint(((ACTellEdgeStep)instance).constraint());
                Scope sourceValue = ((ACTellEdgeStep)instance).source();
                if (sourceValue != null) {
                    this.source(sourceValue);
                }
                if ((targetValue = ((ACTellEdgeStep)instance).target()) != null) {
                    this.target(targetValue);
                }
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CTellEdge constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder source(@Nullable Scope source) {
            this.source = source;
            return this;
        }

        public final Builder target(@Nullable Scope target) {
            this.target = target;
            return this;
        }

        public CTellEdgeStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CTellEdgeStep(null, this.constraint, this.result, this.source, this.target, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CTellEdgeStep, some of required attributes are not set " + attributes;
        }
    }
}

