/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import java.io.Serializable;
import java.util.Collection;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.substitution.IReplacement;
import mb.statix.solver.ITermProperty;
import org.metaborg.util.collection.ConsList;

public class BagTermProperty
implements ITermProperty,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ConsList<ITerm> values;

    private BagTermProperty(ConsList<ITerm> values) {
        this.values = values;
    }

    @Override
    public ITermProperty.Multiplicity multiplicity() {
        return ITermProperty.Multiplicity.BAG;
    }

    @Override
    public ITerm value() {
        throw new UnsupportedOperationException("Bag property does not have a single value.");
    }

    @Override
    public Collection<ITerm> values() {
        return this.values;
    }

    @Override
    public ITermProperty addValue(ITerm value) {
        return new BagTermProperty(this.values.prepend(value));
    }

    @Override
    public ITermProperty replace(IReplacement replacement) {
        ITermProperty newProp = BagTermProperty.of();
        this.values.forEach(val -> {
            ITermProperty iTermProperty2 = newProp.addValue(replacement.apply((ITerm)val));
        });
        return newProp;
    }

    public static ITermProperty of() {
        return new BagTermProperty(ConsList.nil());
    }

    public static ITermProperty of(ITerm value) {
        return new BagTermProperty(ConsList.of(value));
    }
}

