/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public final class CEqual
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm term1;
    private final ITerm term2;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;
    @Nullable
    private final CEqual origin;
    private final int hashCode = this.computeHashCode();

    public CEqual(ITerm term1, ITerm term2) {
        this(term1, term2, null, null, null);
    }

    public CEqual(ITerm term1, ITerm term2, @Nullable IMessage message) {
        this(term1, term2, null, message, null);
    }

    public CEqual(ITerm term1, ITerm term2, @Nullable IConstraint cause) {
        this(term1, term2, cause, null, null);
    }

    private CEqual(ITerm term1, ITerm term2, @Nullable IConstraint cause, @Nullable IMessage message, @Nullable CEqual origin) {
        this.term1 = term1;
        this.term2 = term2;
        this.cause = cause;
        this.message = message;
        this.origin = origin;
    }

    public ITerm term1() {
        return this.term1;
    }

    public ITerm term2() {
        return this.term2;
    }

    public CEqual withArguments(ITerm term1, ITerm term2) {
        if (this.term1 == term1 && this.term2 == term2) {
            return this;
        }
        return new CEqual(term1, term2, this.cause, this.message, this.origin);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CEqual withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CEqual(this.term1, this.term2, cause, this.message, this.origin);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CEqual withMessage(@Nullable IMessage message) {
        if (this.message == message) {
            return this;
        }
        return new CEqual(this.term1, this.term2, this.cause, message, this.origin);
    }

    @Override
    @Nullable
    public CEqual origin() {
        return this.origin;
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseEqual(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseEqual(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.term1.getVars(), this.term2.getVars());
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.term1.getVars().forEach(onFreeVar::apply);
        this.term2.getVars().forEach(onFreeVar::apply);
        if (this.message != null) {
            this.message.visitVars(onFreeVar);
        }
    }

    @Override
    public CEqual apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CEqual unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CEqual apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CEqual apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CEqual(subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public CEqual unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return this.apply(subst, trackOrigin);
    }

    @Override
    public CEqual apply(IRenaming subst, boolean trackOrigin) {
        return new CEqual(subst.apply(this.term1), subst.apply(this.term2), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(termToString.format(this.term1));
        sb.append(" == ");
        sb.append(termToString.format(this.term2));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CEqual that = (CEqual)o;
        return this.hashCode == that.hashCode && Objects.equals(this.term1, that.term1) && Objects.equals(this.term2, that.term2) && Objects.equals(this.cause, that.cause) && Objects.equals(this.message, that.message) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.term1, this.term2, this.cause, this.message, this.origin);
    }
}

