/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mb.scopegraph.schema.Cardinality;

public class SchemaEdge<K, L, M> {
    private final Map<K, Cardinality> sources;
    private final Map<K, Cardinality> targets;
    private final L label;
    private final M meta;

    private SchemaEdge(Map<K, Cardinality> sources, Map<K, Cardinality> targets, L label, M meta) {
        if (sources.isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty scheme edge sources.");
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty scheme edge targets.");
        }
        this.sources = sources;
        this.targets = targets;
        this.label = label;
        this.meta = meta;
    }

    public Map<K, Cardinality> getSources() {
        return this.sources;
    }

    public Map<K, Cardinality> getTargets() {
        return this.targets;
    }

    public L getLabel() {
        return this.label;
    }

    public M getMeta() {
        return this.meta;
    }

    public static <K, L, M> Builder<K, L, M> builder(L label, M meta) {
        return new Builder(label, meta);
    }

    /* synthetic */ SchemaEdge(Map map, Map map2, Object object, Object object2, SchemaEdge schemaEdge) {
        this(map, map2, object, object2);
    }

    public static class Builder<K, L, M> {
        private final Map<K, Cardinality> sources = new HashMap<K, Cardinality>();
        private final Map<K, Cardinality> targets = new HashMap<K, Cardinality>();
        private final L label;
        private final M meta;

        private Builder(L label, M meta) {
            this.label = label;
            this.meta = meta;
        }

        public Builder<K, L, M> addSource(K node, Cardinality card) {
            this.sources.put(node, card);
            return this;
        }

        public Builder<K, L, M> addTarget(K node, Cardinality card) {
            this.targets.put(node, card);
            return this;
        }

        public SchemaEdge<K, L, M> build() {
            return new SchemaEdge(Collections.unmodifiableMap(this.sources), Collections.unmodifiableMap(this.targets), this.label, this.meta, null);
        }
    }
}

