/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mb.scopegraph.schema.Cardinality;

public class SchemaDecl<K, L, M> {
    private final Map<K, Cardinality> sources;
    private final Map<Integer, Map<K, Cardinality>> values;
    private final L label;
    private final M meta;

    private SchemaDecl(Map<K, Cardinality> sources, Map<Integer, Map<K, Cardinality>> values, L label, M meta) {
        if (sources.isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty scheme decl sources.");
        }
        this.sources = sources;
        this.values = values;
        this.label = label;
        this.meta = meta;
    }

    public Map<K, Cardinality> getSources() {
        return this.sources;
    }

    public Set<Integer> getValueIndices() {
        return this.values.keySet();
    }

    public Map<K, Cardinality> getValuesAt(int idx) {
        return this.values.getOrDefault(idx, Collections.emptyMap());
    }

    public L getLabel() {
        return this.label;
    }

    public M getMeta() {
        return this.meta;
    }

    public static <K, L, M> Builder<K, L, M> builder(L label, M meta) {
        return new Builder(label, meta);
    }

    /* synthetic */ SchemaDecl(Map map, Map map2, Object object, Object object2, SchemaDecl schemaDecl) {
        this(map, map2, object, object2);
    }

    public static class Builder<K, L, M> {
        private final Map<K, Cardinality> sources = new HashMap<K, Cardinality>();
        private final Map<Integer, Map<K, Cardinality>> values = new HashMap<Integer, Map<K, Cardinality>>();
        private final L label;
        private final M meta;

        private Builder(L label, M meta) {
            this.label = label;
            this.meta = meta;
        }

        public Builder<K, L, M> addSource(K node, Cardinality card) {
            this.sources.put(node, card);
            return this;
        }

        public Builder<K, L, M> addValue(int idx, K node, Cardinality card) {
            this.values.computeIfAbsent(idx, HashMap::new).put(node, card);
            return this;
        }

        public SchemaDecl<K, L, M> build() {
            return new SchemaDecl(Collections.unmodifiableMap(this.sources), Collections.unmodifiableMap(this.values), this.label, this.meta, null);
        }
    }
}

