/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.regexp.impl;

import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.impl.AClosure;

final class Closure<S>
extends AClosure<S>
implements Serializable {
    private final IRegExp<S> rE;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private Closure(IRegExp<S> rE) {
        this.rE = Objects.requireNonNull(rE, "rE");
    }

    private Closure(Closure<S> original, IRegExp<S> rE) {
        this.rE = rE;
    }

    @Override
    public IRegExp<S> getRE() {
        return this.rE;
    }

    public final Closure<S> withRE(IRegExp<S> value) {
        if (this.rE == value) {
            return this;
        }
        IRegExp<S> newValue = Objects.requireNonNull(value, "rE");
        return new Closure<S>(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Closure && this.equalTo(0, (Closure)another);
    }

    private boolean equalTo(int synthetic, Closure<?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.rE.equals(another.rE);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.rE.hashCode();
        return h;
    }

    public static <S> Closure<S> of(IRegExp<S> rE) {
        return new Closure<S>(rE);
    }

    public static <S> Closure<S> copyOf(AClosure<S> instance) {
        if (instance instanceof Closure) {
            return (Closure)instance;
        }
        return Closure.of(instance.getRE());
    }
}

