/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.solvers;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mb.nabl2.config.NaBL2DebugConfig;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.relations.variants.IVariantRelation;
import mb.nabl2.relations.variants.VariantRelations;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.ISolver;
import mb.nabl2.solver.Solution;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.solver.components.AstComponent;
import mb.nabl2.solver.components.BaseComponent;
import mb.nabl2.solver.components.EqualityComponent;
import mb.nabl2.solver.components.NameResolutionComponent;
import mb.nabl2.solver.components.NameResolutionResult;
import mb.nabl2.solver.components.NameSetsComponent;
import mb.nabl2.solver.components.RelationComponent;
import mb.nabl2.solver.components.SetComponent;
import mb.nabl2.solver.components.SymbolicComponent;
import mb.nabl2.solver.exceptions.SolverException;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.properties.HasRelationBuildConstraints;
import mb.nabl2.solver.solvers.BaseMultiFileSolver;
import mb.nabl2.solver.solvers.CallExternal;
import mb.nabl2.solver.solvers.FixedPointSolver;
import mb.nabl2.symbolic.ISymbolicConstraints;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IProperties;
import mb.scopegraph.pepm16.ScopeGraphReducer;
import mb.scopegraph.pepm16.esop15.CriticalEdge;
import mb.scopegraph.pepm16.esop15.IEsopNameResolution;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import org.metaborg.util.Ref;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Predicate1;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class SemiIncrementalMultiFileSolver
extends BaseMultiFileSolver {
    public SemiIncrementalMultiFileSolver(NaBL2DebugConfig nabl2Debug, CallExternal callExternal) {
        super(nabl2Debug, callExternal);
    }

    public ISolution solveInter(ISolution initial, Iterable<? extends ISolution> unitSolutions, IMessageInfo message, Function1<String, String> fresh, ICancel cancel, IProgress progress) throws SolverException, InterruptedException {
        SolverConfig config = initial.config();
        Ref<IUnifier.Immutable> unifier = new Ref<IUnifier.Immutable>(initial.unifier());
        IEsopScopeGraph.Transient<Scope, Label, Occurrence, ITerm> scopeGraph = initial.scopeGraph().melt();
        IEsopNameResolution<Scope, Label, Occurrence> nameResolution = IEsopNameResolution.of(config.getResolutionParams(), scopeGraph, (s, l) -> true);
        ScopeGraphReducer scopeGraphReducer = new ScopeGraphReducer(scopeGraph, unifier);
        HasRelationBuildConstraints hasRelationBuildConstraints = new HasRelationBuildConstraints();
        Predicate1<String> isRelationComplete = r -> !hasRelationBuildConstraints.contains((String)r);
        SolverCore core = new SolverCore(config, unifier, fresh, this.callExternal, cancel, progress);
        AstComponent astSolver = new AstComponent(core, initial.astProperties().melt());
        BaseComponent baseSolver = new BaseComponent(core);
        EqualityComponent equalitySolver = new EqualityComponent(core, unifier);
        NameResolutionComponent nameResolutionSolver = new NameResolutionComponent(core, scopeGraph, nameResolution, initial.declProperties().melt());
        NameSetsComponent nameSetSolver = new NameSetsComponent(core, nameResolution);
        RelationComponent relationSolver = new RelationComponent(core, isRelationComplete, config.getFunctions(), (Map<String, IVariantRelation.Transient<ITerm>>)VariantRelations.melt(initial.relations()));
        SetComponent setSolver = new SetComponent(core, nameSetSolver.nameSets());
        SymbolicComponent symSolver = new SymbolicComponent(core, initial.symbolic());
        ISolver component = c -> c.matchOrThrow(IConstraint.CheckedCases.builder().onBase(baseSolver::solve).onEquality(equalitySolver::solve).onNameResolution(nameResolutionSolver::solve).onRelation(relationSolver::solve).onSet(setSolver::solve).onSym(symSolver::solve).otherwise(ISolver.defer()));
        FixedPointSolver solver = new FixedPointSolver(cancel, progress, component);
        solver.step().subscribe(r -> {
            hasRelationBuildConstraints.addAll((Iterable<IConstraint>)r.result.constraints());
            r.resolveRelations((Iterable<String>)hasRelationBuildConstraints.remove(r.constraint));
            Set.Immutable<ITermVar> vars = r.result.unifierDiff().domainSet();
            if (!vars.isEmpty()) {
                try {
                    List<CriticalEdge> criticalEdges = scopeGraphReducer.update((Iterable<? extends ITerm>)vars);
                    nameResolution.update(criticalEdges, cancel, progress);
                    r.resolveCriticalEdges(criticalEdges);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        try {
            HashSet<IConstraint> constraints = new HashSet<IConstraint>((Collection<IConstraint>)initial.constraints());
            IMessages.Transient messages = initial.messages().melt();
            for (ISolution iSolution : unitSolutions) {
                this.seed(astSolver.seed(iSolution.astProperties(), message), messages, constraints);
                this.seed(equalitySolver.seed(iSolution.unifier(), message), messages, constraints);
                NameResolutionResult nameResult = NameResolutionResult.of(iSolution.scopeGraph(), iSolution.nameResolutionCache(), iSolution.declProperties());
                this.seed(nameResolutionSolver.seed(nameResult, message), messages, constraints);
                this.seed(relationSolver.seed((Map<String, IVariantRelation.Immutable<ITerm>>)iSolution.relations(), message), messages, constraints);
                this.seed(symSolver.seed(iSolution.symbolic(), message), messages, constraints);
                constraints.addAll((Collection<IConstraint>)iSolution.constraints());
                messages.addAll(iSolution.messages());
            }
            scopeGraphReducer.updateAll();
            hasRelationBuildConstraints.addAll(constraints);
            SolveResult solveResult = solver.solve(constraints, unifier);
            messages.addAll(solveResult.messages());
            IProperties.Immutable<TermIndex, ITerm, ITerm> astResult = astSolver.finish();
            NameResolutionResult nameResolutionResult = nameResolutionSolver.finish();
            IUnifier.Immutable unifierResult = equalitySolver.finish();
            Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relationResult = relationSolver.finish();
            ISymbolicConstraints symbolicConstraints = symSolver.finish();
            setSolver.finish();
            Solution solution = Solution.of(config, astResult, nameResolutionResult.scopeGraph(), nameResolutionResult.declProperties(), relationResult, unifierResult, symbolicConstraints, messages.freeze(), solveResult.constraints()).withNameResolutionCache(nameResolutionResult.resolutionCache());
            return solution;
        }
        catch (RuntimeException ex) {
            throw new SolverException("Internal solver error.", ex);
        }
    }
}

