/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.relations.variants.IVariantRelation;
import mb.nabl2.relations.variants.VariantRelations;
import mb.nabl2.solver.ISolution;
import mb.nabl2.solver.Solution;
import mb.nabl2.solver.SolverConfig;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.solver.messages.Messages;
import mb.nabl2.symbolic.ISymbolicConstraints;
import mb.nabl2.symbolic.SymbolicConstraints;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.unification.Unifiers;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.util.collections.IProperties;
import mb.nabl2.util.collections.Properties;
import mb.scopegraph.pepm16.esop15.IEsopNameResolution;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.esop15.reference.EsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.OccurrenceIndex;
import mb.scopegraph.pepm16.terms.Scope;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.CapsuleUtil;

@Value.Immutable(builder=true)
@Serial.Version(value=42L)
public abstract class ASolution
implements ISolution {
    @Override
    @Value.Parameter
    public abstract SolverConfig config();

    @Override
    @Value.Parameter
    public abstract IProperties.Immutable<TermIndex, ITerm, ITerm> astProperties();

    @Override
    @Value.Parameter
    public abstract IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph();

    @Override
    @Value.Lazy
    public SetMultimap.Immutable<OccurrenceIndex, Occurrence> astDecls() {
        SetMultimap.Transient astDecls = SetMultimap.Transient.of();
        this.scopeGraph().getAllDecls().forEach(o -> astDecls.__insert((Object)o.getIndex(), o));
        return astDecls.freeze();
    }

    @Override
    @Value.Lazy
    public SetMultimap.Immutable<OccurrenceIndex, Occurrence> astRefs() {
        SetMultimap.Transient astRefs = SetMultimap.Transient.of();
        this.scopeGraph().getAllRefs().forEach(o -> astRefs.__insert((Object)o.getIndex(), o));
        return astRefs.freeze();
    }

    @Override
    public IEsopNameResolution<Scope, Label, Occurrence> nameResolution() {
        IEsopNameResolution<Scope, Label, Occurrence> nr = IEsopNameResolution.of(this.config().getResolutionParams(), this.scopeGraph(), (s, l) -> true, this.nameResolutionCache());
        return nr;
    }

    @Override
    @Value.Default
    public IEsopNameResolution.IResolutionCache<Scope, Label, Occurrence> nameResolutionCache() {
        return IEsopNameResolution.IResolutionCache.empty();
    }

    @Override
    @Value.Parameter
    public abstract IProperties.Immutable<Occurrence, ITerm, ITerm> declProperties();

    @Override
    @Value.Parameter
    public abstract Map.Immutable<String, IVariantRelation.Immutable<ITerm>> relations();

    @Override
    @Value.Parameter
    public abstract IUnifier.Immutable unifier();

    @Override
    @Value.Parameter
    public abstract ISymbolicConstraints symbolic();

    @Override
    @Value.Parameter
    public abstract IMessages.Immutable messages();

    @Override
    @Value.Parameter
    public abstract Set.Immutable<IConstraint> constraints();

    public static ISolution of(SolverConfig config) {
        return Solution.of(config, Properties.Immutable.of(), EsopScopeGraph.Immutable.of(), Properties.Immutable.of(), VariantRelations.immutableOf(config.getRelations()), Unifiers.Immutable.of(), SymbolicConstraints.of(), Messages.Immutable.of(), CapsuleUtil.immutableSet());
    }
}

