/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.variants;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mb.nabl2.relations.variants.AVariantRelationDescription;
import mb.nabl2.relations.variants.IVariantMatcher;
import mb.scopegraph.relations.RelationDescription;

public final class VariantRelationDescription<T>
extends AVariantRelationDescription<T>
implements Serializable {
    private final RelationDescription relationDescription;
    private final List<IVariantMatcher<T>> variantMatchers;
    private static final long serialVersionUID = 42L;

    private VariantRelationDescription(RelationDescription relationDescription, Iterable<? extends IVariantMatcher<T>> variantMatchers) {
        this.relationDescription = Objects.requireNonNull(relationDescription, "relationDescription");
        this.variantMatchers = VariantRelationDescription.createUnmodifiableList(false, VariantRelationDescription.createSafeList(variantMatchers, true, false));
    }

    private VariantRelationDescription(VariantRelationDescription<T> original, RelationDescription relationDescription, List<IVariantMatcher<T>> variantMatchers) {
        this.relationDescription = relationDescription;
        this.variantMatchers = variantMatchers;
    }

    @Override
    public RelationDescription relationDescription() {
        return this.relationDescription;
    }

    @Override
    public List<IVariantMatcher<T>> variantMatchers() {
        return this.variantMatchers;
    }

    public final VariantRelationDescription<T> withRelationDescription(RelationDescription value) {
        if (this.relationDescription == value) {
            return this;
        }
        RelationDescription newValue = Objects.requireNonNull(value, "relationDescription");
        return new VariantRelationDescription<T>(this, newValue, this.variantMatchers);
    }

    @SafeVarargs
    public final VariantRelationDescription<T> withVariantMatchers(IVariantMatcher<T> ... elements) {
        List<IVariantMatcher<T>> newValue = VariantRelationDescription.createUnmodifiableList(false, VariantRelationDescription.createSafeList(Arrays.asList(elements), true, false));
        return new VariantRelationDescription<T>(this, this.relationDescription, newValue);
    }

    public final VariantRelationDescription<T> withVariantMatchers(Iterable<? extends IVariantMatcher<T>> elements) {
        if (this.variantMatchers == elements) {
            return this;
        }
        List<IVariantMatcher<T>> newValue = VariantRelationDescription.createUnmodifiableList(false, VariantRelationDescription.createSafeList(elements, true, false));
        return new VariantRelationDescription<T>(this, this.relationDescription, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VariantRelationDescription && this.equalTo(0, (VariantRelationDescription)another);
    }

    private boolean equalTo(int synthetic, VariantRelationDescription<?> another) {
        return this.relationDescription.equals(another.relationDescription) && this.variantMatchers.equals(another.variantMatchers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationDescription.hashCode();
        h += (h << 5) + this.variantMatchers.hashCode();
        return h;
    }

    public String toString() {
        return "VariantRelationDescription{relationDescription=" + this.relationDescription + ", variantMatchers=" + this.variantMatchers + "}";
    }

    public static <T> VariantRelationDescription<T> of(RelationDescription relationDescription, List<IVariantMatcher<T>> variantMatchers) {
        return VariantRelationDescription.of(relationDescription, variantMatchers);
    }

    public static <T> VariantRelationDescription<T> of(RelationDescription relationDescription, Iterable<? extends IVariantMatcher<T>> variantMatchers) {
        return new VariantRelationDescription<T>(relationDescription, variantMatchers);
    }

    public static <T> VariantRelationDescription<T> copyOf(AVariantRelationDescription<T> instance) {
        if (instance instanceof VariantRelationDescription) {
            return (VariantRelationDescription)instance;
        }
        return VariantRelationDescription.of(instance.relationDescription(), instance.variantMatchers());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

