/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.terms;

import io.usethesource.capsule.Map;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import mb.nabl2.relations.terms.NamedFunction;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.matching.Pattern;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.matching.TermPattern;
import mb.nabl2.terms.substitution.ISubstitution;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.PartialFunction1;
import org.metaborg.util.tuple.Tuple2;

public class FunctionTerms {
    public static TermMatch.IMatcher<Map.Immutable<String, PartialFunction1<ITerm, ITerm>>> functions() {
        return TermMatch.M.listElems(FunctionTerms.function(), (l, funDefs) -> {
            Map.Transient functions = CapsuleUtil.transientMap();
            for (Tuple2 funDef : funDefs) {
                functions.__put((Object)((String)funDef._1()), (Object)((PartialFunction1)funDef._2()));
            }
            return functions.freeze();
        });
    }

    private static TermMatch.IMatcher<Tuple2<String, Eval>> function() {
        return TermMatch.M.tuple2(NamedFunction.matcher(), TermMatch.M.listElems(FunctionTerms.functionCase()), (t, name, cases) -> Tuple2.of(name.getName(), new Eval((List)cases)));
    }

    private static TermMatch.IMatcher<Tuple2<Pattern, ITerm>> functionCase() {
        return TermMatch.M.tuple2(TermMatch.M.term(), TermMatch.M.term(), (t, pattern, term) -> {
            if (!pattern.getVars().containsAll(term.getVars())) {
                throw new IllegalStateException("Function case is not closed.");
            }
            return Tuple2.of(TermPattern.P.fromTerm((ITerm)pattern), term);
        });
    }

    public static class Eval
    implements PartialFunction1<ITerm, ITerm>,
    Serializable {
        private static final long serialVersionUID = 42L;
        private final List<Tuple2<Pattern, ITerm>> cases;

        private Eval(List<Tuple2<Pattern, ITerm>> cases) {
            this.cases = ImList.Immutable.copyOf(cases);
        }

        @Override
        public Optional<ITerm> apply(ITerm term) {
            if (!term.isGround()) {
                throw new IllegalStateException("Term argument must be ground.");
            }
            for (Tuple2<Pattern, ITerm> c : this.cases) {
                Pattern pattern = c._1();
                ISubstitution.Immutable matchResult = pattern.match(term).orElse(null);
                if (matchResult == null) continue;
                ITerm result = matchResult.apply(c._2());
                return Optional.of(result);
            }
            return Optional.empty();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.cases.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Eval other = (Eval)obj;
            return this.cases.equals(other.cases);
        }
    }
}

