/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import java.util.Collections;
import java.util.List;
import mb.flowspec.terms.B;
import mb.flowspec.terms.IStrategoAppl2;
import mb.flowspec.terms.TermIndex;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.StrategoConstructor;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.TermList;

public interface ICFGNode
extends IStrategoAppl2 {
    public static final int ARITY = 3;
    public static final String NAME = "CFGNode";

    public TermIndex getIndex();

    public String getCFGNodeName();

    public Kind getKind();

    @Override
    default public TermIndex termIndex() {
        return this.getIndex();
    }

    @Override
    default public String getName() {
        return NAME;
    }

    @Override
    default public int getSubtermCount() {
        return 3;
    }

    @Override
    default public IStrategoTerm[] getAllSubterms() {
        return new IStrategoTerm[]{this.getIndex(), B.string(this.getName()), this.getKind()};
    }

    @Override
    default public List<IStrategoTerm> getSubterms() {
        return TermList.ofUnsafe(this.getIndex(), B.string(this.getName()), this.getKind());
    }

    @Override
    default public boolean match(IStrategoTerm second) {
        if (second instanceof ICFGNode) {
            ICFGNode other = (ICFGNode)second;
            return this.getIndex().equals(other.getIndex()) && this.getName().equals(other.getName()) && this.getKind().equals(other.getKind());
        }
        return second.match(this);
    }

    public static enum Kind implements IStrategoAppl2
    {
        Normal,
        Start,
        End,
        Entry,
        Exit;

        private static IStrategoConstructor consNormal;
        private static IStrategoConstructor consStart;
        private static IStrategoConstructor consEnd;
        private static IStrategoConstructor consEntry;
        private static IStrategoConstructor consExit;

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public int getSubtermCount() {
            return 0;
        }

        @Override
        public IStrategoTerm[] getAllSubterms() {
            return TermFactory.EMPTY_TERM_ARRAY;
        }

        @Override
        public List<IStrategoTerm> getSubterms() {
            return Collections.emptyList();
        }

        @Override
        public boolean match(IStrategoTerm second) {
            if (this == second) {
                return true;
            }
            return second.match(this);
        }

        public static void initializeConstructor(ITermFactory tf) {
            consNormal = tf.makeConstructor(Normal.name(), 0);
            consStart = tf.makeConstructor(Start.name(), 0);
            consEnd = tf.makeConstructor(End.name(), 0);
            consEntry = tf.makeConstructor(Entry.name(), 0);
            consExit = tf.makeConstructor(Exit.name(), 0);
        }

        @Override
        public IStrategoConstructor getConstructor() {
            switch (this) {
                case Normal: {
                    return consNormal != null ? consNormal : new StrategoConstructor(this.getName(), this.getSubtermCount());
                }
                case Start: {
                    return consStart != null ? consStart : new StrategoConstructor(this.getName(), this.getSubtermCount());
                }
                case End: {
                    return consEnd != null ? consEnd : new StrategoConstructor(this.getName(), this.getSubtermCount());
                }
                case Entry: {
                    return consEntry != null ? consEntry : new StrategoConstructor(this.getName(), this.getSubtermCount());
                }
                case Exit: {
                    return consExit != null ? consExit : new StrategoConstructor(this.getName(), this.getSubtermCount());
                }
            }
            return new StrategoConstructor(this.getName(), this.getSubtermCount());
        }
    }
}

