/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oracle.pg.rdbms.AdbGraphClientConfiguration;
import oracle.pg.rdbms.EnvironmentStatus;
import oracle.pg.rdbms.GraphServer;
import oracle.pg.rdbms.Job;
import oracle.pg.rdbms.exception.GraphClientException;
import oracle.pg.rdbms.internal.adb.BrokerClient;
import oracle.pg.rdbms.internal.adb.BrokerRealmClient;
import oracle.pg.rdbms.internal.adb.GraphStudioClient;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.realm.client.RealmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdbGraphClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AdbGraphClient.class);
    private final AdbGraphClientConfiguration config;
    private final URI endpoint;
    private final ExecutorService executorService;
    private final BrokerClient brokerClient;
    private final GraphStudioClient graphStudioClient;
    private RealmClient realmClient;
    private final boolean externalThreadPool;
    private final String pgxBaseUrl;

    public AdbGraphClient(AdbGraphClientConfiguration config) {
        this.config = config;
        if (config.getEndpoint() == null) {
            throw new GraphClientException("Please provide endpoint", null);
        }
        try {
            this.endpoint = new URI(config.getEndpoint());
        }
        catch (URISyntaxException e) {
            throw new GraphClientException("invalid URL given: " + config.getEndpoint(), null, e);
        }
        log.info("endpoint = {}", (Object)this.endpoint);
        if (config.getTenancyOcid() == null && config.getTenant() == null) {
            throw new GraphClientException("Please provide tenancy OCID", null);
        }
        if (config.getDatabase() == null) {
            throw new GraphClientException("Please provide database name", null);
        }
        if (config.getDatabaseOcid() == null && config.getCloudDatabaseName() == null) {
            throw new GraphClientException("Please provide database OCID", null);
        }
        if (config.getUsername() == null) {
            throw new GraphClientException("Please provide username", null);
        }
        if (config.getPassword() == null) {
            throw new GraphClientException("Please provide password", null);
        }
        URI brokerBaseURI = config.createBrokerBaseURI();
        log.info("broker base URI = {}", (Object)brokerBaseURI);
        this.brokerClient = new BrokerClient(config, brokerBaseURI);
        String token = this.brokerClient.createToken(config.getUsername(), config.getPassword());
        this.realmClient = new BrokerRealmClient(config, brokerBaseURI, token);
        boolean bl = this.externalThreadPool = config.getExecutorService() != null;
        if (this.externalThreadPool) {
            this.executorService = config.getExecutorService();
        } else {
            int numCPUs = Runtime.getRuntime().availableProcessors();
            log.info("creating new thread pool with {} threads", (Object)numCPUs);
            this.executorService = Executors.newFixedThreadPool(numCPUs);
        }
        URI graphStudioBaseURI = config.createGraphStudioBaseURI();
        log.info("Graph Studio base URI = {}", (Object)graphStudioBaseURI);
        this.graphStudioClient = new GraphStudioClient(config, this.executorService, graphStudioBaseURI, () -> ((RealmClient)this.realmClient).getToken());
        this.pgxBaseUrl = config.createPgxBaseURI().toString();
        log.info("PGX base URI = {}", (Object)this.pgxBaseUrl);
        this.graphStudioClient.getUser();
    }

    public boolean isAttached() {
        return this.getEnvironmentStatus() == EnvironmentStatus.ATTACHED;
    }

    public EnvironmentStatus getEnvironmentStatus() {
        return this.graphStudioClient.getEnvironmentStatus();
    }

    public Job startEnvironment(int memory) {
        this.verifyDetached();
        return this.graphStudioClient.attachEnvironment(memory).poll();
    }

    public Job stopEnvironment() {
        this.verifyAttached();
        return this.graphStudioClient.detachEnvironment().poll();
    }

    public Job restartEnvironment() {
        this.verifyAttached();
        return this.graphStudioClient.reattachEnvironment().poll();
    }

    public ServerInstance getPgxInstance() {
        this.verifyAttached();
        return GraphServer.addVersionInfo(Pgx.getInstance((String)this.pgxBaseUrl, (RealmClient)this.realmClient));
    }

    public double getCurrentMemory() {
        this.verifyAttached();
        return this.graphStudioClient.getEnvironmentUsedMemory();
    }

    public double getAvailableMemory() {
        this.verifyDetached();
        return this.graphStudioClient.getEnvironmentAvailableMemory();
    }

    @Override
    public void close() {
        if (!this.externalThreadPool) {
            this.executorService.shutdown();
        }
    }

    private void verifyDetached() {
        switch (this.getEnvironmentStatus()) {
            case ATTACHED: {
                throw new IllegalStateException("environment currently attached to database " + this.config.getDatabase());
            }
            case ATTACHING: 
            case RESTARTING: {
                throw new IllegalStateException("environment is currently attaching to database " + this.config.getDatabase() + ". Wait for job to complete");
            }
            case DETACHING: {
                throw new IllegalStateException("environment is currently detaching from database " + this.config.getDatabase() + ". Wait for job to complete");
            }
        }
    }

    private void verifyAttached() {
        switch (this.getEnvironmentStatus()) {
            case DETACHED: {
                throw new IllegalStateException("environment currently detached from database " + this.config.getDatabase());
            }
            case ATTACHING: 
            case RESTARTING: {
                throw new IllegalStateException("environment is currently attaching to database " + this.config.getDatabase() + ". Wait for job to complete");
            }
            case DETACHING: {
                throw new IllegalStateException("environment is currently detaching from database " + this.config.getDatabase() + ". Wait for job to complete");
            }
        }
    }

    public AdbGraphClientConfiguration getConfig() {
        return this.config;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }
}

