/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.function.Function;
import oracle.pgx.common.Either;
import oracle.pgx.common.pojo.EntityProviderConfigContainerDeserializer;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.ObfuscationFacade;
import oracle.pgx.config.AnyFormatEntityProviderConfigFactory;
import oracle.pgx.config.EntityProviderConfig;

@JsonDeserialize(using=EntityProviderConfigContainerDeserializer.class)
public class EntityProviderConfigContainer {
    private static final ObfuscationFacade OBFUSCATION_FACADE = new ObfuscationFacade();
    private final Either<EntityProviderConfig, String> graphConfig;

    private EntityProviderConfigContainer(Either<EntityProviderConfig, String> graphConfig) {
        this.graphConfig = graphConfig;
    }

    @JsonValue
    public Object getValue() {
        return this.graphConfig.map(Function.identity(), Function.identity());
    }

    public EntityProviderConfig getConfig(String password) {
        return (EntityProviderConfig)this.graphConfig.map(Function.identity(), encrypted -> this.decrypt((String)encrypted, password));
    }

    private EntityProviderConfig decrypt(String encrypted, String password) {
        String decrypt = OBFUSCATION_FACADE.deobfuscate(encrypted, password);
        try {
            return (EntityProviderConfig)new DeserializerEntityProviderConfigFactory().fromJson(decrypt);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static EntityProviderConfigContainer createClear(EntityProviderConfig config) {
        return new EntityProviderConfigContainer((Either<EntityProviderConfig, String>)Either.left((Object)config));
    }

    public static EntityProviderConfigContainer createObfuscated(EntityProviderConfig config, String password) {
        try {
            String json = JsonUtil.toJson((Object)config);
            String encrypted = OBFUSCATION_FACADE.obfuscate(json, password);
            return EntityProviderConfigContainer.fromObfuscatedRaw(encrypted);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static EntityProviderConfigContainer fromObfuscatedRaw(String encryptedGraphConfig) {
        return new EntityProviderConfigContainer((Either<EntityProviderConfig, String>)Either.right((Object)encryptedGraphConfig));
    }

    private static class DeserializerEntityProviderConfigFactory
    extends AnyFormatEntityProviderConfigFactory {
        DeserializerEntityProviderConfigFactory() {
            super(true, true);
        }
    }
}

