/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph.internal;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.function.Supplier;
import oracle.pgx.common.util.AuthCertUtils;
import oracle.pgx.common.util.ErrorMessages;

@FunctionalInterface
public interface KeystoreLookup {
    public String getPasswordForAlias(String var1) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException;

    public static KeystoreLookup forKeystoreProvider(Supplier<String> keystorePath, Supplier<char[]> keystorePassword) {
        return alias -> {
            String path = (String)keystorePath.get();
            if (path == null) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEYSTORE_NOT_SET", (Object[])new Object[0]));
            }
            return AuthCertUtils.getPasswordFromKeystore((String)path, (char[])((char[])keystorePassword.get()), (String)alias);
        };
    }
}

