/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.mllib.UnsupervisedEdgeWiseModelMetadata;
import oracle.pgx.api.mllib.EdgeWiseModelBuilder;
import oracle.pgx.api.mllib.UnsupervisedEdgeWiseModel;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.UnsupervisedEdgeWiseModelConfig;

public class UnsupervisedEdgeWiseModelBuilder
extends EdgeWiseModelBuilder<UnsupervisedEdgeWiseModel, UnsupervisedEdgeWiseModelConfig, UnsupervisedEdgeWiseModelBuilder> {
    private final PgxSession session;
    private final Core core;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final BiFunction<PgxSession, Graph, PgxGraph> graphConstructor;

    public UnsupervisedEdgeWiseModelBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier, BiFunction<PgxSession, Graph, PgxGraph> graphConstructor) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.modelConfig = new UnsupervisedEdgeWiseModelConfig();
        this.graphConstructor = graphConstructor;
    }

    public UnsupervisedEdgeWiseModelBuilder setDgiLayerConfig(GraphWiseDgiLayerConfig layerConfig) {
        ((UnsupervisedEdgeWiseModelConfig)this.modelConfig).setDgiLayerConfig(layerConfig);
        return this;
    }

    public UnsupervisedEdgeWiseModelBuilder setLossFunction(UnsupervisedEdgeWiseModelConfig.LossFunction lossFunction) {
        ((UnsupervisedEdgeWiseModelConfig)this.modelConfig).setLossFunction(lossFunction);
        return this;
    }

    @Override
    public UnsupervisedEdgeWiseModel build() throws InterruptedException, ExecutionException {
        super.validateAll();
        UnsupervisedEdgeWiseModelMetadata metadata = new UnsupervisedEdgeWiseModelMetadata(null, (UnsupervisedEdgeWiseModelConfig)this.modelConfig);
        return (UnsupervisedEdgeWiseModel)((PgxFuture)this.core.createUnsupervisedEdgeWiseModel(this.session.getSessionContext(), metadata).thenApply(metaData -> new UnsupervisedEdgeWiseModel(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, this.graphConstructor, (UnsupervisedEdgeWiseModelMetadata)((Object)metaData)))).get();
    }

    @Override
    protected UnsupervisedEdgeWiseModelBuilder getThis() {
        return this;
    }
}

