/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWiseDominantLayerConfig;
import oracle.pgx.config.mllib.GraphWisePredictionLayerConfig;

public class GraphWiseDominantLayerConfigBuilder {
    private final GraphWiseDominantLayerConfig dominatLayerConfig = new GraphWiseDominantLayerConfig();

    private void validateAlpha() {
        if (this.dominatLayerConfig.getAlpha() < 0.0 || this.dominatLayerConfig.getAlpha() > 1.0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_ALPHA", (Object[])new Object[]{this.dominatLayerConfig.getAlpha()}));
        }
    }

    public GraphWiseDominantLayerConfigBuilder setDecoderLayerConfigs(GraphWisePredictionLayerConfig ... layerConfigs) {
        this.dominatLayerConfig.setDecoderLayerConfigs(layerConfigs);
        return this;
    }

    public GraphWiseDominantLayerConfigBuilder setAlpha(double alpha) {
        this.dominatLayerConfig.setAlpha(alpha);
        return this;
    }

    public GraphWiseDominantLayerConfig build() {
        this.validateAlpha();
        return this.dominatLayerConfig;
    }
}

