/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.mllib;

import java.util.Collection;
import oracle.pgx.api.internal.mllib.ModelMetadata;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.mllib.ModelKind;
import oracle.pgx.config.mllib.Pg2vecModelConfig;

public class Pg2vecModelMetadata
extends ModelMetadata {
    private String modelName;
    private int walkLength = 5;
    private int walksPerVertex = 4;
    private int minWordFrequency = 1;
    private int batchSize = 128;
    private int numEpochs = 2;
    private int layerSize = 200;
    private double learningRate = 0.025;
    private double minLearningRate = 0.001;
    private int windowSize = 5;
    private Collection<String> vertexPropertyNames = null;
    private String graphLetIdName = null;
    private PropertyType graphIdPropertyType;
    private Double trainingLoss = null;
    private boolean useGraphletSize = true;
    private Long seed = null;
    private boolean shuffle = false;
    private boolean enableAccelerator = true;
    private String graphletSizePropertyName = "graphletSize-Pg2vec";

    public Pg2vecModelMetadata() {
        super(ModelKind.PG2VEC);
    }

    public Pg2vecModelMetadata(String modelName, Pg2vecModelMetadata configMetaData) {
        super(ModelKind.PG2VEC);
        this.modelName = modelName;
        this.walkLength = configMetaData.getWalkLength();
        this.walksPerVertex = configMetaData.getWalksPerVertex();
        this.minWordFrequency = configMetaData.getMinWordFrequency();
        this.batchSize = configMetaData.getBatchSize();
        this.numEpochs = configMetaData.getNumEpochs();
        this.layerSize = configMetaData.getLayerSize();
        this.learningRate = configMetaData.getLearningRate();
        this.minLearningRate = configMetaData.getMinLearningRate();
        this.windowSize = configMetaData.getWindowSize();
        this.vertexPropertyNames = configMetaData.getVertexPropertyNames();
        this.graphLetIdName = configMetaData.getGraphLetIdPropertyName();
        this.graphIdPropertyType = configMetaData.getGraphIdPropertyType();
        this.useGraphletSize = configMetaData.getUseGraphletSize();
        this.trainingLoss = configMetaData.getLoss();
        this.seed = configMetaData.getSeed();
        this.graphletSizePropertyName = configMetaData.getGraphletSizePropertyName();
        this.shuffle = configMetaData.isShuffle();
        this.enableAccelerator = configMetaData.isEnableAccelerator();
    }

    public Pg2vecModelMetadata(String modelName, Pg2vecModelConfig modelConfig) {
        this.modelName = modelName;
        this.walkLength = modelConfig.getWalkLength();
        this.walksPerVertex = modelConfig.getWalksPerVertex();
        this.minWordFrequency = modelConfig.getMinWordFrequency();
        this.batchSize = modelConfig.getBatchSize();
        this.numEpochs = modelConfig.getNumEpochs();
        this.layerSize = modelConfig.getLayerSize();
        this.learningRate = modelConfig.getLearningRate();
        this.minLearningRate = modelConfig.getMinLearningRate();
        this.windowSize = modelConfig.getWindowSize();
        this.vertexPropertyNames = modelConfig.getVertexPropertyNames();
        this.useGraphletSize = modelConfig.getUseGraphletSize();
        this.trainingLoss = modelConfig.getLoss();
        this.graphLetIdName = modelConfig.getGraphLetIdPropertyName();
        this.graphIdPropertyType = modelConfig.getGraphIdPropertyType();
        this.seed = modelConfig.getSeed();
        this.graphletSizePropertyName = modelConfig.getGraphletSizePropertyName();
        this.shuffle = modelConfig.isShuffle();
        this.enableAccelerator = modelConfig.isEnableAccelerator();
    }

    public Boolean getUseGraphletSize() {
        return this.useGraphletSize;
    }

    public void setUseGraphletSize(Boolean useGraphletSize) {
        this.useGraphletSize = useGraphletSize;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Double getLoss() {
        return this.trainingLoss;
    }

    public void setLoss(Double trainingLoss) {
        this.trainingLoss = trainingLoss;
    }

    public int getWalkLength() {
        return this.walkLength;
    }

    public void setWalkLength(int walkLength) {
        this.walkLength = walkLength;
    }

    public int getWalksPerVertex() {
        return this.walksPerVertex;
    }

    public void setWalksPerVertex(int walksPerVertex) {
        this.walksPerVertex = walksPerVertex;
    }

    public int getMinWordFrequency() {
        return this.minWordFrequency;
    }

    public void setMinWordFrequency(int minWordFrequency) {
        this.minWordFrequency = minWordFrequency;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    public int getLayerSize() {
        return this.layerSize;
    }

    public void setLayerSize(int layerSize) {
        this.layerSize = layerSize;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getMinLearningRate() {
        return this.minLearningRate;
    }

    public void setMinLearningRate(double minLearningRate) {
        this.minLearningRate = minLearningRate;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public Collection<String> getVertexPropertyNames() {
        return this.vertexPropertyNames;
    }

    public void setVertexPropertyNames(Collection<String> vertexPropertyNames) {
        this.vertexPropertyNames = vertexPropertyNames;
    }

    public String getGraphLetIdPropertyName() {
        return this.graphLetIdName;
    }

    public void setGraphLetIdPropertyName(String graphLetIdName) {
        this.graphLetIdName = graphLetIdName;
    }

    public PropertyType getGraphIdPropertyType() {
        return this.graphIdPropertyType;
    }

    public void setGraphIdPropertyType(PropertyType graphIdPropertyType) {
        this.graphIdPropertyType = graphIdPropertyType;
    }

    public String getGraphletSizePropertyName() {
        return this.graphletSizePropertyName;
    }

    public void setGraphletSizePropertyName(String graphletSizePropertyName) {
        this.graphletSizePropertyName = graphletSizePropertyName;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public boolean isEnableAccelerator() {
        return this.enableAccelerator;
    }

    public void setEnableAccelerator(boolean enableAccelerator) {
        this.enableAccelerator = enableAccelerator;
    }
}

