/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema.internal.dispatchers.collection;

import java.util.function.Function;
import oracle.pgx.api.frames.schema.datatypes.DataType;
import oracle.pgx.api.frames.schema.datatypes.collection.VectorType;
import oracle.pgx.api.frames.schema.datatypes.numeric.DoubleType;
import oracle.pgx.api.frames.schema.datatypes.numeric.FloatType;
import oracle.pgx.api.frames.schema.datatypes.numeric.IntegerType;
import oracle.pgx.api.frames.schema.datatypes.numeric.LongType;
import oracle.pgx.api.frames.schema.internal.dispatchers.DataTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.DoubleTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.FloatTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.IntegerTypeDispatcher;
import oracle.pgx.api.frames.schema.internal.dispatchers.numeric.LongTypeDispatcher;

@FunctionalInterface
public interface VectorTypeDispatcher<R>
extends Function<VectorType, R> {
    public static <R> VectorTypeDispatcher<R> dispatcher(final IntegerTypeDispatcher<R> integerTypeDispatcher, final LongTypeDispatcher<R> longTypeDispatcher, final FloatTypeDispatcher<R> floatTypeDispatcher, final DoubleTypeDispatcher<R> doubleTypeDispatcher) {
        return new DefaultVectorTypeDispatcher<R>(){

            @Override
            public R applyIntegerType(IntegerType type) {
                return DataTypeDispatcher.applyType(integerTypeDispatcher, type);
            }

            @Override
            public R applyLongType(LongType type) {
                return DataTypeDispatcher.applyType(longTypeDispatcher, type);
            }

            @Override
            public R applyFloatType(FloatType type) {
                return DataTypeDispatcher.applyType(floatTypeDispatcher, type);
            }

            @Override
            public R applyDoubleType(DoubleType type) {
                return DataTypeDispatcher.applyType(doubleTypeDispatcher, type);
            }
        };
    }

    public static <R> R dispatch(IntegerTypeDispatcher<R> integerTypeDispatcher, LongTypeDispatcher<R> longTypeDispatcher, FloatTypeDispatcher<R> floatTypeDispatcher, DoubleTypeDispatcher<R> doubleTypeDispatcher, VectorType dataType) {
        return VectorTypeDispatcher.dispatcher(integerTypeDispatcher, longTypeDispatcher, floatTypeDispatcher, doubleTypeDispatcher).apply(dataType);
    }

    public static interface DefaultVectorTypeDispatcher<R>
    extends VectorTypeDispatcher<R> {
        @Override
        default public R apply(VectorType dataType) {
            DataType valueType = dataType.getValueType();
            if (valueType instanceof IntegerType) {
                return (R)DataTypeDispatcher.applyType(this::applyIntegerType, (IntegerType)valueType);
            }
            if (valueType instanceof LongType) {
                return (R)DataTypeDispatcher.applyType(this::applyLongType, (LongType)valueType);
            }
            if (valueType instanceof FloatType) {
                return (R)DataTypeDispatcher.applyType(this::applyFloatType, (FloatType)valueType);
            }
            if (valueType instanceof DoubleType) {
                return (R)DataTypeDispatcher.applyType(this::applyDoubleType, (DoubleType)valueType);
            }
            return (R)DataTypeDispatcher.throwNoDispatcherForType(dataType);
        }

        default public R applyIntegerType(IntegerType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyLongType(LongType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyFloatType(FloatType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }

        default public R applyDoubleType(DoubleType type) {
            return (R)DataTypeDispatcher.throwNoDispatcherForType(type);
        }
    }
}

