/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.admin.Control;
import oracle.pgx.common.MemoryUnit;
import oracle.pgx.common.pojo.admin.ResourceElasticityStatus;

public class ElasticityController {
    private PgxFuture<Control> control;

    public ElasticityController(PgxFuture<Control> control) {
        this.control = control;
    }

    private <T> PgxFuture<T> onControl(Function<Control, PgxFuture<T>> fun) {
        return this.control.thenCompose(fun);
    }

    public ResourceElasticityStatus getResourceElasticityStatus() throws InterruptedException, ExecutionException {
        return (ResourceElasticityStatus)this.onControl(Control::getResourceElasticityStatus).get();
    }

    public Void updateMaxAttainableResources(int memorySize, MemoryUnit memoryUnit) throws InterruptedException, ExecutionException {
        this.onControl(ctrl -> ctrl.updateMaxAttainableResources(memorySize, memoryUnit)).get();
        return null;
    }

    public JsonNode addHost(String hostname) throws InterruptedException, ExecutionException {
        return (JsonNode)this.onControl(ctrl -> ctrl.addHost(hostname)).get();
    }

    public JsonNode removeHost(String hostname) throws InterruptedException, ExecutionException {
        return (JsonNode)this.onControl(ctrl -> ctrl.removeHost(hostname)).get();
    }
}

