/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.UCPErrorHandler;

@ProxyFor(value={OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class StatementProxy
implements LogicalObject,
Diagnosable {
    static final String CLASS_NAME = StatementProxy.class.getName();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile Chain.Atom<StatementProxy> statementChainAtom = null;
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;
    private volatile boolean sqlWithQueryTimeoutInProgress = false;
    private volatile int queryTimeout = 0;
    private static final Set<String> queryMethods = new HashSet<String>();

    void setStatementChainAtom(Chain.Atom<StatementProxy> atom) {
        this.statementChainAtom = atom;
    }

    @GetDelegate
    protected abstract Statement getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    UniversalPooledConnection getUPC() {
        ConnectionProxyBase c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = (ConnectionProxyBase)this.getCreator())) {
            upc = this.proxiedPooledConnection = c.getUPC();
        }
        return upc;
    }

    UniversalConnectionPool getUCP() {
        ConnectionProxyBase c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = (ConnectionProxyBase)this.getCreator())) {
            ucp = this.proxiedPool = c.getUCP();
        }
        return ucp;
    }

    @Override
    public boolean isLogicallyClosed() {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        return this.closed.get();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        return (Connection)this.getCreator();
    }

    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.queryTimeout = queryTimeout;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.getDelegate().setQueryTimeout(queryTimeout);
        upc.heartbeat();
    }

    public void closeOnCompletion() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        this.getDelegate().closeOnCompletion();
        upc.heartbeat();
    }

    public boolean isClosed() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        return this.closed.get() || this.getDelegate().isClosed() || ((ConnectionProxyBase)this.getCreator()).closed.get();
    }

    public void close() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.statementChainAtom.remove();
        this.getDelegate().close();
        upc.heartbeat();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                Statement t = this.getDelegate();
                return (T)t;
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="getACProxy", args={}), @Signature(name="getExecuteBatch", args={}), @Signature(name="getFixedString", args={}), @Signature(name="getRowPrefetch", args={}), @Signature(name="getcacheState", args={}), @Signature(name="getserverCursor", args={}), @Signature(name="getstatementType", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="setCheckBindTypes", args={boolean.class}), @Signature(name="setDisableStmtCaching", args={boolean.class}), @Signature(name="setFixedString", args={boolean.class}), @Signature(name="setFormOfUse", args={int.class, short.class}), @Signature(name="setLongPrefetch", args={boolean.class})})
    protected void preNoThrow(Method m, Object receiver, Object ... args) {
        try {
            this.pre(m, receiver, args);
        }
        catch (SQLException e) {
            throw new ProxyException(e);
        }
    }

    private static boolean isQueryMethod(Method m) {
        return queryMethods.contains(Objects.requireNonNull(m).getName());
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        XAResource xares;
        ConnectionProxyBase connProxy;
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (StatementProxy.isQueryMethod(m)) {
            this.sqlWithQueryTimeoutInProgress = this.queryTimeout > 0;
            this.getUPC().setSqlWithQueryTimeoutInProgress(this.sqlWithQueryTimeoutInProgress);
        }
        if ((connProxy = (ConnectionProxyBase)this.getCreator()).isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        if (WLSJTAPlugin.jtaWLSEnabled && connProxy.getDelegate() instanceof LogicalConnection && (xares = ((OracleConnection)connProxy.getDelegate()).getXAResource()) != null) {
            WLSJTAPlugin.enlistXAResource(xares);
        }
    }

    @Post
    protected Object postRest(Method m, Object result) {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (StatementProxy.isQueryMethod(m)) {
            this.sqlWithQueryTimeoutInProgress = false;
            this.getUPC().setSqlWithQueryTimeoutInProgress(false);
        }
        return result;
    }

    @Post
    protected void postRestVoid(Method m) {
        this.getUPC().heartbeat();
    }

    @OnError(value=SQLException.class)
    protected void onSQLExceptionErrorVoid(Method m, SQLException e) throws SQLException {
        this.onSQLExceptionError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onSQLExceptionError(Method m, SQLException e) throws SQLException {
        int errNo;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((ConnectionProxyBase)this.getCreator()).handleSQLException(e);
        if (e != null && ((errNo = e.getErrorCode()) == 45582 || errNo == 45583)) {
            upc.getDelegator().onError(errNo);
        }
        throw e;
    }

    @OnError(value=RuntimeException.class)
    protected void onRuntimeErrorVoid(Method m, RuntimeException e) throws RuntimeException {
        this.onRuntimeError(m, e);
    }

    @OnError(value=RuntimeException.class)
    protected Object onRuntimeError(Method m, RuntimeException e) throws RuntimeException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((ConnectionProxyBase)this.getCreator()).handleRuntimeException(e);
        throw e;
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof StatementProxy ? ((StatementProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public Diagnosable getDiagnosable() {
        UniversalConnectionPool ucp = this.getUCP();
        assert (Objects.nonNull(ucp));
        return ucp.getDiagnosable();
    }

    static {
        queryMethods.add("execute");
        queryMethods.add("executeUpdate");
        queryMethods.add("executeLargeUpdate");
        queryMethods.add("executeQuery");
        queryMethods.add("executeBatch");
        queryMethods.add("executeLargeBatch");
        queryMethods.add("getGenerateKeys");
        queryMethods.add("getMoreResults");
    }
}

