/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.jdbc;

import java.util.HashMap;
import java.util.Map;

public class PgqlJdbcHintClause {
    private static final String AUTO_COMMIT_OPTIONS = "AUTO_COMMIT=";
    public static final String AUTO_COMMIT_OPTIONS_TRUE = "AUTO_COMMIT=T,";
    public static final String AUTO_COMMIT_OPTIONS_FALSE = "AUTO_COMMIT=F,";
    private final boolean isSql;
    private final int parallelDop;
    private final int dynamicSamplingLevel;
    private final String options;
    private final String matchOptions;

    public int getParallelDop() {
        return this.parallelDop;
    }

    public int getDynamicSamplingLevel() {
        return this.dynamicSamplingLevel;
    }

    public String getOptions() {
        return this.options;
    }

    public String getMatchOptions() {
        return this.matchOptions;
    }

    public boolean getIsSql() {
        return this.isSql;
    }

    private PgqlJdbcHintClause(Builder builder) {
        this.parallelDop = builder.parallelDop;
        this.dynamicSamplingLevel = builder.dynamicSamplingLevel;
        this.options = builder.options;
        this.matchOptions = builder.matchOptions;
        this.isSql = builder.isSql;
    }

    public static PgqlJdbcHintClause parse(String query) {
        return Parser.parseHints(query);
    }

    private static class Parser {
        private static final int NO_PARALLEL_DOP = 0;
        private static final int DEFAULT_DYNAMIC_SAMPLING_LEVEL = 2;
        private static final String PARALLEL = "PARALLEL";
        private static final String DYNAMIC_SAMPLING = "DYNAMIC_SAMPLING";
        private static final String OPTIONS = "OPTIONS";
        private static final String MATCH_OPTIONS = "MATCH_OPTIONS";
        private static final String IS_SQL = "IS_SQL";
        private static final char[] PARALLEL_HINT = "PARALLEL".toCharArray();
        private static final char[] DYNAMIC_SAMPING_HINT = "DYNAMIC_SAMPLING".toCharArray();
        private static final char[] OPTIONS_HINT = "OPTIONS".toCharArray();
        private static final char[] MATCH_OPTIONS_HINT = "MATCH_OPTIONS".toCharArray();
        private static final char[] AUTO_COMMIT_OPTIONS_HINT = "AUTO_COMMIT=".toCharArray();
        private static final char[] IS_SQL_HINT = "IS_SQL".toCharArray();
        private static final char[] FROM = "FROM".toCharArray();
        private static final char[] INTO = "INTO".toCharArray();
        private static final char[] SELECT = "SELECT".toCharArray();
        private static final char[] INSERT = "INSERT".toCharArray();
        private static final char[] UPDATE = "UPDATE".toCharArray();
        private static final char[] DELETE = "DELETE".toCharArray();

        private Parser() {
        }

        public static PgqlJdbcHintClause parseHints(String query) {
            char[] chars = query.toCharArray();
            HashMap<String, Object> hints = new HashMap<String, Object>();
            hints.put(PARALLEL, 0);
            hints.put(DYNAMIC_SAMPLING, 2);
            hints.put(OPTIONS, "");
            hints.put(MATCH_OPTIONS, "");
            hints.put(IS_SQL, false);
            Builder builder = new Builder();
            int index = 0;
            int startHintClausePosition = 0;
            int endHintClausePosition = 0;
            while (index < chars.length) {
                if (Parser.isSelect(chars, index)) {
                    index += SELECT.length;
                    continue;
                }
                if (Parser.isInsert(chars, index)) {
                    index += INSERT.length;
                    continue;
                }
                if (Parser.isUpdate(chars, index)) {
                    index += UPDATE.length;
                    continue;
                }
                if (Parser.isDelete(chars, index)) {
                    index += DELETE.length;
                    continue;
                }
                if (Parser.isFrom(chars, index) || Parser.isInto(chars, index)) break;
                if (Parser.isStartHintClause(chars, index)) {
                    startHintClausePosition = index += 3;
                    continue;
                }
                if (Parser.isEndHintClause(chars, index)) {
                    endHintClausePosition = index - 1;
                    break;
                }
                ++index;
            }
            if (startHintClausePosition > 0 && endHintClausePosition > 0) {
                int position = startHintClausePosition;
                while (position <= endHintClausePosition) {
                    if (Parser.isParallelHint(chars, position)) {
                        position += PARALLEL_HINT.length;
                        position = Parser.parseHint(chars, position, endHintClausePosition, PARALLEL, hints, HintValueType.NUMBER);
                        continue;
                    }
                    if (Parser.isDynamicSamplingHint(chars, position)) {
                        position += DYNAMIC_SAMPING_HINT.length;
                        position = Parser.parseHint(chars, position, endHintClausePosition, DYNAMIC_SAMPLING, hints, HintValueType.NUMBER);
                        continue;
                    }
                    if (Parser.isOptionsHint(chars, position)) {
                        position += OPTIONS_HINT.length;
                        position = Parser.parseHint(chars, position, endHintClausePosition, OPTIONS, hints, HintValueType.STRING);
                        continue;
                    }
                    if (Parser.isMatchOptionsHint(chars, position)) {
                        position += MATCH_OPTIONS_HINT.length;
                        position = Parser.parseHint(chars, position, endHintClausePosition, MATCH_OPTIONS, hints, HintValueType.STRING);
                        continue;
                    }
                    if (Parser.isSqlHint(chars, position)) {
                        position += IS_SQL_HINT.length;
                        position = Parser.parseHint(chars, position, endHintClausePosition, IS_SQL, hints, HintValueType.BOOLEAN);
                        continue;
                    }
                    ++position;
                }
            }
            return builder.dynamicSamplingLevel((Integer)hints.get(DYNAMIC_SAMPLING)).parallelDop((Integer)hints.get(PARALLEL)).options((String)hints.get(OPTIONS)).matchOptions((String)hints.get(MATCH_OPTIONS)).isSql((Boolean)hints.get(IS_SQL)).build();
        }

        private static int parseHint(char[] chars, int index, int endHintClausePosition, String targetHintName, Map<String, Object> result, HintValueType type) {
            int currentPosition = index;
            int startArgValuePosition = 0;
            int endArgValuePosition = 0;
            while (currentPosition <= endHintClausePosition) {
                if (Parser.isStartArg(chars, currentPosition)) {
                    startArgValuePosition = ++currentPosition;
                    continue;
                }
                if (Parser.isEndArg(chars, currentPosition)) {
                    endArgValuePosition = currentPosition - 1;
                    break;
                }
                ++currentPosition;
            }
            if (startArgValuePosition > 0 && endArgValuePosition > 0) {
                switch (type) {
                    case NUMBER: {
                        try {
                            int value = Parser.parseNumber(chars, startArgValuePosition, endArgValuePosition);
                            result.put(targetHintName, value);
                        }
                        catch (NumberFormatException value) {}
                        break;
                    }
                    case STRING: {
                        String value = Parser.parseString(chars, startArgValuePosition, endArgValuePosition);
                        result.put(targetHintName, value);
                        break;
                    }
                    case BOOLEAN: {
                        boolean booleanValue = Parser.parseBoolean(chars, startArgValuePosition);
                        result.put(targetHintName, booleanValue);
                    }
                }
            }
            return currentPosition;
        }

        private static int parseNumber(char[] chars, int startIndex, int endIndex) {
            StringBuilder sb = new StringBuilder();
            for (int currentIndex = startIndex; currentIndex <= endIndex; ++currentIndex) {
                char c = chars[currentIndex];
                if (!Character.isDigit(c)) {
                    throw new NumberFormatException();
                }
                sb.append(c);
            }
            return Integer.parseInt(sb.toString());
        }

        private static String parseString(char[] chars, int startIndex, int endIndex) {
            int currentIndex = startIndex;
            StringBuilder sb = new StringBuilder();
            while (currentIndex <= endIndex) {
                if (Parser.isAutoCommit(chars, currentIndex)) {
                    if (!Parser.isComma(chars, currentIndex = currentIndex + AUTO_COMMIT_OPTIONS_HINT.length + 1)) continue;
                    ++currentIndex;
                    continue;
                }
                char c = chars[currentIndex];
                sb.append(c);
                ++currentIndex;
            }
            return sb.toString();
        }

        private static boolean parseBoolean(char[] chars, int startIndex) {
            return Parser.isCharAtIndex(chars, startIndex, 'T');
        }

        private static boolean isParallelHint(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, PARALLEL_HINT);
        }

        private static boolean isAutoCommit(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, AUTO_COMMIT_OPTIONS_HINT);
        }

        private static boolean isDynamicSamplingHint(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, DYNAMIC_SAMPING_HINT);
        }

        private static boolean isOptionsHint(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, OPTIONS_HINT);
        }

        private static boolean isMatchOptionsHint(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, MATCH_OPTIONS_HINT);
        }

        private static boolean isSqlHint(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, IS_SQL_HINT);
        }

        private static boolean isSelect(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, SELECT);
        }

        private static boolean isInsert(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, INSERT);
        }

        private static boolean isDelete(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, DELETE);
        }

        private static boolean isUpdate(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, UPDATE);
        }

        private static boolean isInto(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, INTO);
        }

        private static boolean isFrom(char[] chars, int index) {
            return Parser.areMoreCharsAtIndex(chars, index, FROM);
        }

        private static boolean isStartArg(char[] chars, int index) {
            return Parser.isCharAtIndex(chars, index, '(');
        }

        private static boolean isEndArg(char[] chars, int index) {
            return Parser.isCharAtIndex(chars, index, ')');
        }

        private static boolean isComma(char[] chars, int index) {
            return Parser.isCharAtIndex(chars, index, ',');
        }

        private static boolean isStartHintClause(char[] chars, int index) {
            return Parser.areThreeCharsAtIndex(chars, index, '/', '*', '+');
        }

        private static boolean isEndHintClause(char[] chars, int index) {
            return Parser.areTwoCharsAtIndex(chars, index, '*', '/');
        }

        private static boolean isCharAtIndex(char[] chars, int index, char c) {
            if (index >= chars.length) {
                return false;
            }
            return chars[index] == c;
        }

        private static boolean areTwoCharsAtIndex(char[] chars, int index, char char1, char char2) {
            if (index + 1 >= chars.length) {
                return false;
            }
            return chars[index] == char1 && chars[index + 1] == char2;
        }

        private static boolean areThreeCharsAtIndex(char[] chars, int index, char char1, char char2, char char3) {
            if (index + 2 >= chars.length) {
                return false;
            }
            return chars[index] == char1 && chars[index + 1] == char2 && chars[index + 2] == char3;
        }

        private static boolean areMoreCharsAtIndex(char[] chars, int index, char[] targetChars) {
            if (index + targetChars.length >= chars.length) {
                return false;
            }
            for (int i = 0; i < targetChars.length; ++i) {
                if (targetChars[i] == chars[i + index]) continue;
                return false;
            }
            return true;
        }

        private static enum HintValueType {
            NUMBER,
            STRING,
            BOOLEAN;

        }
    }

    private static class Builder {
        private int parallelDop = 0;
        private int dynamicSamplingLevel = 2;
        private String options = "";
        private String matchOptions = "";
        private boolean isSql = false;

        private Builder() {
        }

        private Builder parallelDop(int dop) {
            this.parallelDop = dop;
            return this;
        }

        private Builder dynamicSamplingLevel(int level) {
            this.dynamicSamplingLevel = level;
            return this;
        }

        private Builder options(String options) {
            this.options = options;
            return this;
        }

        private Builder matchOptions(String matchOptions) {
            this.matchOptions = matchOptions;
            return this;
        }

        private Builder isSql(boolean isSql) {
            this.isSql = isSql;
            return this;
        }

        private PgqlJdbcHintClause build() {
            return new PgqlJdbcHintClause(this);
        }
    }
}

