/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyServerAdapter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class JettyModernServerAdapter
extends JettyServerAdapter {
    public JettyModernServerAdapter(Request jettyRequest, Response jettyResponse) {
        super(jettyRequest, jettyResponse);
    }

    @Override
    public long getContentLength() {
        return this.response.getHttpChannel().getBytesWritten();
    }

    @Override
    public int getStatusCode() {
        return this.response.getCommittedMetaData().getStatus();
    }

    @Override
    public long getRequestTimestamp() {
        return this.request.getTimeStamp();
    }

    @Override
    public Map<String, String> buildResponseHeaderMap() {
        HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
        for (HttpField httpField : this.response.getHttpFields()) {
            String key = httpField.getName();
            String value = httpField.getValue();
            responseHeaderMap.put(key, value);
        }
        return responseHeaderMap;
    }
}

