/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.common.types.IdType;
import oracle.pgx.config.AbstractGraphConfigBuilder;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.TwoTablesDatastore;
import oracle.pgx.config.TwoTablesRdbmsGraphConfig;
import oracle.pgx.config.TwoTablesRdbmsGraphConfigFactory;

public final class TwoTablesRdbmsGraphConfigBuilder
extends AbstractGraphConfigBuilder<TwoTablesRdbmsGraphConfigBuilder, TwoTablesRdbmsGraphConfig> {
    public TwoTablesRdbmsGraphConfigBuilder() {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.FORMAT.toKey(), Format.TWO_TABLES.toString());
        this.setDatastore(TwoTablesDatastore.RDBMS);
        this.setVertexIdType(IdType.LONG);
    }

    @Override
    protected AbstractGraphConfigFactory<TwoTablesRdbmsGraphConfig> getFactory() {
        return new TwoTablesRdbmsGraphConfigFactory(true, true);
    }

    @Override
    public TwoTablesRdbmsGraphConfigBuilder copyFrom(TwoTablesRdbmsGraphConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.setDatastore(graphConfig.getDatastore());
        this.setDataSourceId(graphConfig.getDataSourceId());
        this.setJdbcUrl(graphConfig.getJdbcUrl());
        this.setUsername(graphConfig.getUsername());
        this.setPassword((String)graphConfig.getValues().get(TwoTablesRdbmsGraphConfig.Field.PASSWORD));
        this.setTablespace(graphConfig.getTablespace());
        this.setVerticesTableName(graphConfig.getNodesTableName());
        this.setEdgesTableName(graphConfig.getEdgesTableName());
        this.setNumConnections(graphConfig.getNumConnections());
        this.setNodesKey(graphConfig.getNodesKeyColumn());
        this.setEdgesKey(graphConfig.getEdgesKeyColumn());
        this.setFromNid(graphConfig.getFromNidColumn());
        this.setToNid(graphConfig.getToNidColumn());
        this.setMaxPreFetchedRows(graphConfig.getMaxPrefetchedRows());
        this.setSchema(graphConfig.getSchema());
        this.setInsertBatchSize(graphConfig.getInsertBatchSize());
        this.setLabelValueDelimiter(graphConfig.getLabelValueDelimiter());
        this.setVertexLabels(graphConfig.getNodesLabelColumn());
        this.setEdgeLabel(graphConfig.getEdgesLabelColumn());
        return (TwoTablesRdbmsGraphConfigBuilder)this.getThis();
    }

    public TwoTablesRdbmsGraphConfigBuilder setDatastore(TwoTablesDatastore datastore) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.DATASTORE.toKey(), datastore.toString());
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setDataSourceId(String dsId) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.DATA_SOURCE_ID.toKey(), dsId);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setJdbcUrl(String url) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.JDBC_URL.toKey(), url);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setUsername(String un) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.USERNAME.toKey(), un);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setTablespace(String tablespace) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.TABLESPACE.toKey(), tablespace);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setVerticesTableName(String vtb) {
        return this.setNodesTableName(vtb);
    }

    public TwoTablesRdbmsGraphConfigBuilder setNodesTableName(String ntb) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.NODES_TABLE_NAME.toKey(), ntb);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setEdgesTableName(String etb) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.EDGES_TABLE_NAME.toKey(), etb);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setNumConnections(int c) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.NUM_CONNECTIONS.toKey(), c);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setNodesKey(String nKey) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.NODES_KEY_COLUMN.toKey(), nKey);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setEdgesKey(String eKey) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.EDGES_KEY_COLUMN.toKey(), eKey);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setFromNid(String fromNid) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.FROM_NID_COLUMN.toKey(), fromNid);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setToNid(String toNid) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.TO_NID_COLUMN.toKey(), toNid);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setMaxPreFetchedRows(int maxPreFetchedRows) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.MAX_PREFETCHED_ROWS.toKey(), maxPreFetchedRows);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setSchema(String schema) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.SCHEMA.toKey(), schema);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setInsertBatchSize(int insertBatchSize) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.INSERT_BATCH_SIZE.toKey(), insertBatchSize);
        return this;
    }

    @Override
    public TwoTablesRdbmsGraphConfigBuilder setLabelValueDelimiter(String delimiter) {
        this.loadingValues.put(GraphLoadingConfig.Field.PROPERTY_VALUE_DELIMITER.toKey(), delimiter);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setVertexLabels(String vertexLabels) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.NODES_LABEL_COLUMN.toKey(), vertexLabels);
        return this;
    }

    public TwoTablesRdbmsGraphConfigBuilder setEdgeLabel(String edgeLabel) {
        this.values.put(TwoTablesRdbmsGraphConfig.Field.EDGES_LABEL_COLUMN.toKey(), edgeLabel);
        return this;
    }
}

