/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.ForeignKeyColumnConfig;

public final class ForeignKeyColumnConfigBuilder {
    private final Map<ForeignKeyColumnConfig.Field, Object> values = new HashMap<ForeignKeyColumnConfig.Field, Object>();

    public static ForeignKeyColumnConfig buildForeignKeyColumnConfig(Consumer<ForeignKeyColumnConfigBuilder> builderSetup) {
        ForeignKeyColumnConfigBuilder builder = new ForeignKeyColumnConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public ForeignKeyColumnConfigBuilder() {
    }

    public ForeignKeyColumnConfigBuilder(Map<ForeignKeyColumnConfig.Field, Object> values) {
        this.putAll(values);
    }

    public ForeignKeyColumnConfigBuilder(ForeignKeyColumnConfig config) {
        this.putAll(config);
    }

    public ForeignKeyColumnConfigBuilder(ForeignKeyColumnConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public ForeignKeyColumnConfigBuilder putAll(Map<ForeignKeyColumnConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public ForeignKeyColumnConfigBuilder putAll(ForeignKeyColumnConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public ForeignKeyColumnConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public ForeignKeyColumnConfig build(String parentPath) {
        try {
            return ForeignKeyColumnConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public ForeignKeyColumnConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<ForeignKeyColumnConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "ForeignKeyColumnConfigBuilder" + this.values;
    }

    public ForeignKeyColumnConfigBuilder setName(String name) {
        this.values.put(ForeignKeyColumnConfig.Field.NAME, name);
        return this;
    }

    public ForeignKeyColumnConfigBuilder setReferences(String references) {
        this.values.put(ForeignKeyColumnConfig.Field.REFERENCES, references);
        return this;
    }
}

