# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

# pylint: disable=line-too-long

__all__ = [
    'build_add_connection_to_group_request',
    'build_add_user_to_group_request',
    'build_connection_exists_request',
    'build_group_exists_request',
    'build_check_permission_request',
    'build_user_exists_request',
    'build_close_client_connection_request',
    'build_grant_permission_request',
    'build_healthapi_get_health_status_request',
    'build_remove_connection_from_group_request',
    'build_remove_user_from_all_groups_request',
    'build_remove_user_from_group_request',
    'build_revoke_permission_request',
    'build_send_to_all_request',
    'build_send_to_connection_request',
    'build_send_to_group_request',
    'build_send_to_user_request'
]
from typing import TYPE_CHECKING
from msrest import Serializer
from azure.core.pipeline.transport._base import _format_url_section
from azure.messaging.webpubsubservice.core.rest import HttpRequest

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, IO, List, Optional, Union, Dict
    from typing_extensions import Literal
    Permissions = Union[Literal['joinLeaveGroup'], Literal['sendToGroup']] # pylint: disable=unsubscriptable-object

_SERIALIZER = Serializer()


def build_healthapi_get_health_status_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Get service health status.

    Get service health status.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/health')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_send_to_all_request(
    hub,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Broadcast content inside request body to all the connected client connections.

    Broadcast content inside request body to all the connected client connections.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :keyword json: The payload body.
    :paramtype json: Any
    :keyword content: The payload body.
    :paramtype content: IO
    :keyword excluded: Excluded connection Ids.
    :paramtype excluded: list[str]
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest

    Example:
        .. code-block:: python

            # JSON input template you can fill out and use as your `json` input.
            json = "Any (optional)"
    """
    excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/:send')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if excluded is not None:
        query_parameters['excluded'] = [_SERIALIZER.query("excluded", q, 'str') if q is not None else '' for q in excluded]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_connection_exists_request(
    hub,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Check if the connection with the given connectionId exists.

    Check if the connection with the given connectionId exists.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param connection_id: The connection Id.
    :type connection_id: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/connections/{connectionId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_close_client_connection_request(
    hub,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Close the client connection.

    Close the client connection.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param connection_id: Target connection Id.
    :type connection_id: str
    :keyword reason: The reason closing the client connection.
    :paramtype reason: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    reason = kwargs.pop('reason', None)  # type: Optional[str]
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/connections/{connectionId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if reason is not None:
        query_parameters['reason'] = _SERIALIZER.query("reason", reason, 'str')
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_send_to_connection_request(
    hub,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Send content inside request body to the specific connection.

    Send content inside request body to the specific connection.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param connection_id: The connection Id.
    :type connection_id: str
    :keyword json: The payload body.
    :paramtype json: Any
    :keyword content: The payload body.
    :paramtype content: IO
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest

    Example:
        .. code-block:: python

            # JSON input template you can fill out and use as your `json` input.
            json = "Any (optional)"
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/connections/{connectionId}/:send')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_group_exists_request(
    hub,  # type: str
    group,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Check if there are any client connections inside the given group.

    Check if there are any client connections inside the given group.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param group: Target group name, which length should be greater than 0 and less than 1025.
    :type group: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'group': _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_send_to_group_request(
    hub,  # type: str
    group,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Send content inside request body to a group of connections.

    Send content inside request body to a group of connections.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param group: Target group name, which length should be greater than 0 and less than 1025.
    :type group: str
    :keyword json: The payload body.
    :paramtype json: Any
    :keyword content: The payload body.
    :paramtype content: IO
    :keyword excluded: Excluded connection Ids.
    :paramtype excluded: list[str]
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest

    Example:
        .. code-block:: python

            # JSON input template you can fill out and use as your `json` input.
            json = "Any (optional)"
    """
    excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}/:send')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'group': _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if excluded is not None:
        query_parameters['excluded'] = [_SERIALIZER.query("excluded", q, 'str') if q is not None else '' for q in excluded]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_add_connection_to_group_request(
    hub,  # type: str
    group,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Add a connection to the target group.

    Add a connection to the target group.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param group: Target group name, which length should be greater than 0 and less than 1025.
    :type group: str
    :param connection_id: Target connection Id.
    :type connection_id: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}/connections/{connectionId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'group': _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_remove_connection_from_group_request(
    hub,  # type: str
    group,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Remove a connection from the target group.

    Remove a connection from the target group.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param group: Target group name, which length should be greater than 0 and less than 1025.
    :type group: str
    :param connection_id: Target connection Id.
    :type connection_id: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}/connections/{connectionId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'group': _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_user_exists_request(
    hub,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Check if there are any client connections connected for the given user.

    Check if there are any client connections connected for the given user.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param user_id: Target user Id.
    :type user_id: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'userId': _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_send_to_user_request(
    hub,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Send content inside request body to the specific user.

    Send content inside request body to the specific user.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param user_id: The user Id.
    :type user_id: str
    :keyword json: The payload body.
    :paramtype json: Any
    :keyword content: The payload body.
    :paramtype content: IO
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest

    Example:
        .. code-block:: python

            # JSON input template you can fill out and use as your `json` input.
            json = "Any (optional)"
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]
    content_type = kwargs.pop("content_type", None)

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/:send')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'userId': _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_add_user_to_group_request(
    hub,  # type: str
    group,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Add a user to the target group.

    Add a user to the target group.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param group: Target group name, which length should be greater than 0 and less than 1025.
    :type group: str
    :param user_id: Target user Id.
    :type user_id: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/groups/{group}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'group': _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        'userId': _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_remove_user_from_group_request(
    hub,  # type: str
    group,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Remove a user from the target group.

    Remove a user from the target group.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param group: Target group name, which length should be greater than 0 and less than 1025.
    :type group: str
    :param user_id: Target user Id.
    :type user_id: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/groups/{group}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'group': _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        'userId': _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_remove_user_from_all_groups_request(
    hub,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Remove a user from all groups.

    Remove a user from all groups.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param user_id: Target user Id.
    :type user_id: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/groups')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'userId': _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_grant_permission_request(
    hub,  # type: str
    permission,  # type: Permissions
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Grant permission to the connection.

    Grant permission to the connection.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param permission: The permission: current supported actions are joinLeaveGroup and
     sendToGroup.
    :type permission: str or ~Permissions
    :param connection_id: Target connection Id.
    :type connection_id: str
    :keyword target_name: Optional. If not set, grant the permission to all the targets. If set,
     grant the permission to the specific target. The meaning of the target depends on the specific
     permission.
    :paramtype target_name: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    target_name = kwargs.pop('target_name', None)  # type: Optional[str]
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'permission': _SERIALIZER.url("permission", permission, 'str'),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if target_name is not None:
        query_parameters['targetName'] = _SERIALIZER.query("target_name", target_name, 'str')
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_revoke_permission_request(
    hub,  # type: str
    permission,  # type: Permissions
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Revoke permission for the connection.

    Revoke permission for the connection.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param permission: The permission: current supported actions are joinLeaveGroup and
     sendToGroup.
    :type permission: str or ~Permissions
    :param connection_id: Target connection Id.
    :type connection_id: str
    :keyword target_name: Optional. If not set, revoke the permission for all targets. If set,
     revoke the permission for the specific target. The meaning of the target depends on the
     specific permission.
    :paramtype target_name: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    target_name = kwargs.pop('target_name', None)  # type: Optional[str]
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'permission': _SERIALIZER.url("permission", permission, 'str'),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if target_name is not None:
        query_parameters['targetName'] = _SERIALIZER.query("target_name", target_name, 'str')
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        **kwargs
    )


def build_check_permission_request(
    hub,  # type: str
    permission,  # type: Permissions
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    """Check if a connection has permission to the specified action.

    Check if a connection has permission to the specified action.

    See https://aka.ms/azsdk/python/llcwiki for how to incorporate this request builder into your code flow.

    :param hub: Target hub name, which should start with alphabetic characters and only contain
     alpha-numeric characters or underscore.
    :type hub: str
    :param permission: The permission: current supported actions are joinLeaveGroup and
     sendToGroup.
    :type permission: ~Permissions
    :param connection_id: Target connection Id.
    :type connection_id: str
    :keyword target_name: Optional. If not set, get the permission for all targets. If set, get the
     permission for the specific target. The meaning of the target depends on the specific
     permission.
    :paramtype target_name: str
    :keyword api_version: Api Version.
    :paramtype api_version: str
    :return: Returns an :class:`~azure.messaging.webpubsubservice.core.rest.HttpRequest` that you will pass to the client's `send_request` method.
     See https://aka.ms/azsdk/python/llcwiki for how to incorporate this response into your code flow.
    :rtype: ~azure.messaging.webpubsubservice.core.rest.HttpRequest
    """
    target_name = kwargs.pop('target_name', None)  # type: Optional[str]
    api_version = kwargs.pop('api_version', "2021-05-01-preview")  # type: Optional[str]

    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}')
    path_format_arguments = {
        'hub': _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        'permission': _SERIALIZER.url("permission", permission, 'str'),
        'connectionId': _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }
    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if target_name is not None:
        query_parameters['targetName'] = _SERIALIZER.query("target_name", target_name, 'str')
    if api_version is not None:
        query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        **kwargs
    )
