import string as s
#import re
from numpy import *
#import os
#content=file('neutron_scattering_lengths_short.txt')
#listname=[]
#for line in content:
#    listname.append(s.split(line)[0])
#Please donot change this part
elements=['H', 'D','He', 'Li', 'Be', 'B', 'C', 'N', 'O', 'F', 'Ne', 'Na', 'Mg', 'Al', 'Si', 'P', 'S', 'Cl', 'Ar', 'K', 'Ca', 'Sc', 'Ti', 'V', 'Cr', 'Mn', 'Fe', 'Co', 'Ni', 'Cu', 'Zn', 'Ga', 'Ge', 'As', 'Se', 'Br', 'Kr', 'Rb', 'Sr', 'Y', 'Zr', 'Nb', 'Mo', 'Tc', 'Ru', 'Rh', 'Pd', 'Ag', 'Cd', 'In', 'Sn', 'Sb', 'Te', 'I', 'Xe', 'Cs', 'Ba', 'La', 'Ce', 'Pr', 'Nd', 'Pm', 'Sm', 'Eu', 'Gd', 'Tb', 'Dy', 'Ho', 'Er', 'Tm', 'Yb', 'Lu', 'Hf', 'Ta', 'W', 'Re', 'Os', 'Ir', 'Pt', 'Au', 'Hg', 'Tl', 'Pb', 'Bi', 'Po', 'At', 'Rn', 'Fr', 'Ra', 'Ac', 'Th', 'Pa', 'U', 'Np', 'Pu', 'Am', 'Cm']
bc=['-3.739', '6.671','3.26', '-1.9', '7.79', '5.3', '6.646', '9.36', '5.803', '5.654', '4.566', '3.63', '5.375', '3.449', '4.1491', '5.13', '2.847', '9.577', '1.909', '3.67', '4.7', '12.29', '-3.438', '-0.3824', '3.635', '-3.73', '9.45', '2.49', '10.3', '7.718', '5.68', '7.288', '8.185', '6.58', '7.97', '6.795', '7.81', '7.09', '7.02', '7.75', '7.16', '7.054', '6.715', '6.8', '7.03', '5.88', '5.91', '5.922', '4.87', '4.065', '6.225', '5.57', '5.8', '5.28', '4.92', '5.42', '5.07', '8.24', '4.84', '4.58', '7.69', '12.6', '0.8', '7.22', '6.5', '7.38', '16.9', '8.01', '7.79', '7.07', '12.43', '7.21', '7.7', '6.91', '4.86', '9.2', '10.7', '10.6', '9.6', '7.63', '12.692', '8.776', '9.405', '8.532', '---', '---', '---', '---', '10', '---', '10.31', '9.1', '8.417', '10.55', '---', '8.3', '---']
binc=['---', '4.04','---', '---', '0.12', '---', '---', '---', '---', '-0.082', '---', '3.59', '---', '0.256', '---', '0.2', '---', '---', '---', '---', '---', '-6', '---', '---', '---', '1.79', '---', '-6.2', '---', '---', '---', '---', '---', '-0.69', '---', '---', '---', '---', '---', '1.1', '---', '-0.139', '---', '---', '---', '---', '---', '---', '---', '---', '---', '---', '---', '1.58', '3.04', '1.29', '---', '---', '---', '-0.35', '---', '(+/-)3.2(2.5)', '---', '---', '---', '-0.17', '---', '-1.7', '---', '0.9', '---', '---', '---', '---', '---', '---', '---', '---', '---', '-1.84', '---', '---', '---', '---', '0.259', '---', '---', '---', '0', '---', '0', '---', '---', '---', '---', '(+/-)2.(7.)', '---']
cohxs=['1.7568','5.592', '1.34', '0.454', '7.63', '3.54', '5.551', '11.01', '4.232', '4.017', '2.62', '1.66', '3.631', '1.495', '2.163', '3.307', '1.0186', '11.5257', '0.458', '1.69', '2.78', '19', '1.485', '0.0184', '1.66', '1.75', '11.22', '0.779', '13.3', '7.485', '4.054', '6.675', '8.42', '5.44', '7.98', '5.8', '7.67', '6.32', '6.19', '7.55', '6.44', '6.253', '5.67', '5.8', '6.21', '4.34', '4.39', '4.407', '3.04', '2.08', '4.871', '3.9', '4.23', '3.5', '2.96', '3.69', '3.23', '8.53', '2.94', '2.64', '7.43', '20.0(1.3)', '0.422', '6.57', '29.3', '6.84', '35.9', '8.06', '7.63', '6.28', '19.42', '6.53', '7.6', '6', '2.97', '10.6', '14.4', '14.1', '11.58', '7.32', '20.24', '9.678', '11.115', '9.148', '0', '0', '0', '0', '13.(3.)', '0', '13.36', '10.4', '8.903', '14', '---', '8.7', '0']
incxs=['80.26', '2.05','0', '0.92', '0.0018', '1.7', '0.001', '0.5', '0.0008', '0.0008', '0.008', '1.62', '0.08', '0.0082', '0.004', '0.005', '0.007', '5.3', '0.225', '0.27', '0.05', '4.5', '2.87', '5.08', '1.83', '0.4', '0.4', '4.8', '5.2', '0.55', '0.077', '0.16', '0.18', '0.06', '0.32', '0.1', '0.01', '0.5', '0.06', '0.15', '0.02', '0.0024', '0.04', '0.5', '0.4', '0.3', '0.093', '0.58', '3.46', '0.54', '0.022', '0.007', '0.09', '0.31', '0', '0.21', '0.15', '1.13', '0.001', '0.015', '9.2', '1.3', '39', '2.5', '151', '0.004', '54.4', '0.36', '1.1', '0.1', '4', '0.7', '2.6', '0.01', '1.63', '0.9', '0.3', '0', '0.13', '0.43', '6.6', '0.21', '0.003', '0.0084', '---', '---', '---', '---', '0', '---', '0', '0.1', '0.005', '0.5', '---', '0.3', '---']
scaxs=['82.02', '7.64','1.34', '1.37', '7.63', '5.24', '5.551', '11.51', '4.232', '4.018', '2.628', '3.28', '3.71', '1.503', '2.167', '3.312', '1.026', '16.8', '0.683', '1.96', '2.83', '23.5', '4.35', '5.1', '3.49', '2.15', '11.62', '5.6', '18.5', '8.03', '4.131', '6.83', '8.6', '5.5', '8.3', '5.9', '7.68', '6.8', '6.25', '7.7', '6.46', '6.255', '5.71', '6.3', '6.6', '4.6', '4.48', '4.99', '6.5', '2.62', '4.892', '3.9', '4.32', '3.81', '---', '3.9', '3.38', '9.66', '2.94', '2.66', '16.6', '21.3', '39', '9.2', '180', '6.84', '90.3', '8.42', '8.7', '6.38', '23.4', '7.2', '10.2', '6.01', '4.6', '11.5', '14.7', '14', '11.71', '7.75', '26.8', '9.89', '11.118', '9.156', '---', '---', '12.6', '---', '13', '---', '13.36', '10.5', '8.908', '14.5', '---', '9', '---']
absxs=['0.3326', '0.000519','0.00747', '70.5', '0.0076', '767', '0.0035', '1.9', '0.00019', '0.0096', '0.039', '0.53', '0.063', '0.231', '0.171', '0.172', '0.53', '33.5', '0.675', '2.1', '0.43', '27.5', '6.09', '5.08', '3.05', '13.3', '2.56', '37.18', '4.49', '3.78', '1.11', '2.75', '2.2', '4.5', '11.7', '6.9', '25', '0.38', '1.28', '1.28', '0.185', '1.15', '2.48', '20', '2.56', '144.8', '6.9', '63.3', '2520', '193.8', '0.626', '4.91', '4.7', '6.15', '23.9', '29', '1.1', '8.97', '0.63', '11.5', '50.5', '168.4', '5922', '4530', '49700', '23.4', '994', '64.7', '159', '100', '34.8', '74', '104.1', '20.6', '18.3', '89.7', '16', '425', '10.3', '98.65', '372.3', '3.43', '0.171', '0.0338', '---', '---', '---', '---', '12.8', '---', '7.37', '200.6', '7.57', '175.9', '---', '75.3', '---']
atmmass=[1.0079,2.0140,4.0026,6.9410,9.0122,10.8110,12.0107,14.0067,15.9994,18.9984,20.1797,22.9897,24.3050,26.9815,28.0855,30.9738,32.0650,35.4530,39.9480,39.0983,40.0780,44.9559,47.8670,50.9415,51.9961,54.9380,55.8450,58.9332,58.6934,63.5460,65.3900,69.7230,72.6400,74.9216,78.9600,79.9040,83.8000,85.4678,87.6200,88.9059,91.2240,92.9064,95.9400,98.0000,101.0700,102.9055,106.4200,107.8682,112.4110,114.8180,118.7100,121.7600,127.6000,126.9045,131.2930,132.9055,137.3270,138.9055,140.1160,140.9077,144.2400,145.0000,150.3600,151.9640,157.2500,158.9253,162.5000,164.9303,167.2590,168.9342,173.0400,174.9670,178.4900,180.9479,183.8400,186.2070,190.2300,192.2170,195.0780,196.9665,200.5900,204.3833,207.2000,208.9804,209.0000,210.0000,222.0000,223.0000,226.0000,227.0000,232.0381,231.0359,238.0289,237.0000]
#---------------------------------------------------
#print bc[elements.index('Ti')]

symbol=['D','O']
number=[2,1]

def getTotalScaLen(S,N):
    z=0.
    for i in range(len(S)):
        z=z+eval(bc[elements.index(S[i])])*N[i]
        
    return z

def getTotalXS(S,N,lamda):
    z=0.
    lamthermal=1.8
    for i in range(len(S)):
        z=z+N[i]*(eval(scaxs[elements.index(S[i])])+(lamda/lamthermal)*eval(absxs[elements.index(S[i])]))
    return z

#print getTotalXS(symbol,number,1.8)

##def getatmNumber(S):
##    """
##    This returns the Atomic number of the element with string S
##    """
##    return elements.index(S)+1.
##

def getMolMass(S,N):
    """
    This function returns the molar mass a chemical formula
    in the form  'C 6 H 6 O 2 N 1'
    """
    
    CMa=0.0
    Ma=zeros(len(S),float)
    for i in range(len(S)):
        Ma[i]=atmmass[elements.index(S[i])]
        CMa=CMa+Ma[i]*N[i]
    return CMa

#print atmmass[0]
#print getMolMass(symbol)
    
def ScaLengthDensity(S,N,rho):
    """
    return the electron density and the scattering length density
    """
    Navo=6.0221415e23
    M=getMolMass(S,N)
    b=getTotalScaLen(S,N)
    ED=(rho*b*Navo*1e-13)/M
    return ED

def PeneDepth(S,N,lamda,rho):
    Navo=6.0221415e23
    M=getMolMass(S,N)
    totxs=getTotalXS(S,N,lamda)
    ED=totxs*rho*Navo*1e-24/M
    return 1./ED

#print PeneDepth(symbol,number,1.8,1.0)
    
#print ScaLengthDensity(symbol,number,1.)



