#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = [
    'Click>=6.0',
    # TODO: put package requirements here
]

test_requirements = [
    # TODO: put package test requirements here
]

setup(
    name='mystic_matchmaking',
    version='0.1.0',
    description="A simple matchmaking service you can visualize",
    long_description=readme + '\n\n' + history,
    author="Hu Zhijia",
    author_email='z.jia.hu@gmail.com',
    url='https://github.com/zhijiahu/mystic_matchmaking',
    packages=[
        'mystic_matchmaking',
    ],
    package_dir={'mystic_matchmaking':
                 'mystic_matchmaking'},
    entry_points={
        'console_scripts': [
            'mystic_matchmaking=mystic_matchmaking.cli:main'
        ]
    },
    include_package_data=True,
    install_requires=requirements,
    license="MIT license",
    zip_safe=False,
    keywords='mystic_matchmaking',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Natural Language :: English',
        "Programming Language :: Python :: 2",
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
    ],
    test_suite='tests',
    tests_require=test_requirements
)
