# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobCreateParameters(Model):
    """Parameters supplied to the Create operation.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The region in which to create the job.
    :type location: str
    :param tags: The user specified tags associated with the job.
    :type tags: dict[str, str]
    :param experiment_name: Describe the experiment information of the job
    :type experiment_name: str
    :param priority: Priority associated with the job. Priority associated
     with the job. Priority values can range from -1000 to 1000, with -1000
     being the lowest priority and 1000 being the highest priority. The default
     value is 0. Default value: 0 .
    :type priority: int
    :param cluster: Required. Specifies the Id of the cluster on which this
     job will run.
    :type cluster: ~azure.mgmt.batchai.models.ResourceId
    :param mount_volumes: Information on mount volumes to be used by the job.
     These volumes will be mounted before the job execution and will be
     unmouted after the job completion. The volumes will be mounted at location
     specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
    :type mount_volumes: ~azure.mgmt.batchai.models.MountVolumes
    :param node_count: Required. Number of compute nodes to run the job on.
     The job will be gang scheduled on that many compute nodes
    :type node_count: int
    :param container_settings: If provided the job will run in the specified
     container. If the container was downloaded as part of cluster setup then
     the same container image will be used. If not provided, the job will run
     on the VM.
    :type container_settings: ~azure.mgmt.batchai.models.ContainerSettings
    :param cntk_settings: Specifies the settings for CNTK (aka Microsoft
     Cognitive Toolkit) job.
    :type cntk_settings: ~azure.mgmt.batchai.models.CNTKsettings
    :param py_torch_settings: Specifies the settings for pyTorch job.
    :type py_torch_settings: ~azure.mgmt.batchai.models.PyTorchSettings
    :param tensor_flow_settings: Specifies the settings for Tensor Flow job.
    :type tensor_flow_settings: ~azure.mgmt.batchai.models.TensorFlowSettings
    :param caffe_settings: Specifies the settings for Caffe job.
    :type caffe_settings: ~azure.mgmt.batchai.models.CaffeSettings
    :param caffe2_settings: Specifies the settings for Caffe2 job.
    :type caffe2_settings: ~azure.mgmt.batchai.models.Caffe2Settings
    :param chainer_settings: Specifies the settings for Chainer job.
    :type chainer_settings: ~azure.mgmt.batchai.models.ChainerSettings
    :param custom_toolkit_settings: Specifies the settings for custom tool kit
     job.
    :type custom_toolkit_settings:
     ~azure.mgmt.batchai.models.CustomToolkitSettings
    :param job_preparation: Specifies the command line to be executed before
     tool kit is launched. The specified actions will run on all the nodes that
     are part of the job
    :type job_preparation: ~azure.mgmt.batchai.models.JobPreparation
    :param std_out_err_path_prefix: Required. The path where the Batch AI
     service will upload stdout and stderror of the job.
    :type std_out_err_path_prefix: str
    :param input_directories: Specifies the list of input directories for the
     Job.
    :type input_directories: list[~azure.mgmt.batchai.models.InputDirectory]
    :param output_directories: Specifies the list of output directories.
    :type output_directories: list[~azure.mgmt.batchai.models.OutputDirectory]
    :param environment_variables: Additional environment variables to set on
     the job. Batch AI will setup these additional environment variables for
     the job.
    :type environment_variables:
     list[~azure.mgmt.batchai.models.EnvironmentVariable]
    :param secrets: Additional environment variables with secret values to set
     on the job. Batch AI will setup these additional environment variables for
     the job. Server will never report values of these variables back.
    :type secrets:
     list[~azure.mgmt.batchai.models.EnvironmentVariableWithSecretValue]
    :param constraints: Constraints associated with the Job.
    :type constraints: ~azure.mgmt.batchai.models.JobBasePropertiesConstraints
    """

    _validation = {
        'location': {'required': True},
        'cluster': {'required': True},
        'node_count': {'required': True},
        'std_out_err_path_prefix': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'experiment_name': {'key': 'properties.experimentName', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'cluster': {'key': 'properties.cluster', 'type': 'ResourceId'},
        'mount_volumes': {'key': 'properties.mountVolumes', 'type': 'MountVolumes'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'int'},
        'container_settings': {'key': 'properties.containerSettings', 'type': 'ContainerSettings'},
        'cntk_settings': {'key': 'properties.cntkSettings', 'type': 'CNTKsettings'},
        'py_torch_settings': {'key': 'properties.pyTorchSettings', 'type': 'PyTorchSettings'},
        'tensor_flow_settings': {'key': 'properties.tensorFlowSettings', 'type': 'TensorFlowSettings'},
        'caffe_settings': {'key': 'properties.caffeSettings', 'type': 'CaffeSettings'},
        'caffe2_settings': {'key': 'properties.caffe2Settings', 'type': 'Caffe2Settings'},
        'chainer_settings': {'key': 'properties.chainerSettings', 'type': 'ChainerSettings'},
        'custom_toolkit_settings': {'key': 'properties.customToolkitSettings', 'type': 'CustomToolkitSettings'},
        'job_preparation': {'key': 'properties.jobPreparation', 'type': 'JobPreparation'},
        'std_out_err_path_prefix': {'key': 'properties.stdOutErrPathPrefix', 'type': 'str'},
        'input_directories': {'key': 'properties.inputDirectories', 'type': '[InputDirectory]'},
        'output_directories': {'key': 'properties.outputDirectories', 'type': '[OutputDirectory]'},
        'environment_variables': {'key': 'properties.environmentVariables', 'type': '[EnvironmentVariable]'},
        'secrets': {'key': 'properties.secrets', 'type': '[EnvironmentVariableWithSecretValue]'},
        'constraints': {'key': 'properties.constraints', 'type': 'JobBasePropertiesConstraints'},
    }

    def __init__(self, **kwargs):
        super(JobCreateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.experiment_name = kwargs.get('experiment_name', None)
        self.priority = kwargs.get('priority', 0)
        self.cluster = kwargs.get('cluster', None)
        self.mount_volumes = kwargs.get('mount_volumes', None)
        self.node_count = kwargs.get('node_count', None)
        self.container_settings = kwargs.get('container_settings', None)
        self.cntk_settings = kwargs.get('cntk_settings', None)
        self.py_torch_settings = kwargs.get('py_torch_settings', None)
        self.tensor_flow_settings = kwargs.get('tensor_flow_settings', None)
        self.caffe_settings = kwargs.get('caffe_settings', None)
        self.caffe2_settings = kwargs.get('caffe2_settings', None)
        self.chainer_settings = kwargs.get('chainer_settings', None)
        self.custom_toolkit_settings = kwargs.get('custom_toolkit_settings', None)
        self.job_preparation = kwargs.get('job_preparation', None)
        self.std_out_err_path_prefix = kwargs.get('std_out_err_path_prefix', None)
        self.input_directories = kwargs.get('input_directories', None)
        self.output_directories = kwargs.get('output_directories', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.secrets = kwargs.get('secrets', None)
        self.constraints = kwargs.get('constraints', None)
