# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationGatewayRewriteRuleCondition(Model):
    """Set of conditions in the Rewrite Rule in Application Gateway.

    :param variable: The condition parameter of the RewriteRuleCondition.
    :type variable: str
    :param pattern: The pattern, either fixed string or regular expression,
     that evaluates the truthfulness of the condition
    :type pattern: str
    :param ignore_case: Setting this paramter to truth value with force the
     pattern to do a case in-sensitive comparison.
    :type ignore_case: bool
    :param negate: Setting this value as truth will force to check the
     negation of the condition given by the user.
    :type negate: bool
    """

    _attribute_map = {
        'variable': {'key': 'variable', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'negate': {'key': 'negate', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGatewayRewriteRuleCondition, self).__init__(**kwargs)
        self.variable = kwargs.get('variable', None)
        self.pattern = kwargs.get('pattern', None)
        self.ignore_case = kwargs.get('ignore_case', None)
        self.negate = kwargs.get('negate', None)
