# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NetworkSecurityRulesEvaluationResult(Model):
    """Network security rules evaluation result.

    :param name: Name of the network security rule.
    :type name: str
    :param protocol_matched: Value indicating whether protocol is matched.
    :type protocol_matched: bool
    :param source_matched: Value indicating whether source is matched.
    :type source_matched: bool
    :param source_port_matched: Value indicating whether source port is
     matched.
    :type source_port_matched: bool
    :param destination_matched: Value indicating whether destination is
     matched.
    :type destination_matched: bool
    :param destination_port_matched: Value indicating whether destination port
     is matched.
    :type destination_port_matched: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol_matched': {'key': 'protocolMatched', 'type': 'bool'},
        'source_matched': {'key': 'sourceMatched', 'type': 'bool'},
        'source_port_matched': {'key': 'sourcePortMatched', 'type': 'bool'},
        'destination_matched': {'key': 'destinationMatched', 'type': 'bool'},
        'destination_port_matched': {'key': 'destinationPortMatched', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(NetworkSecurityRulesEvaluationResult, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol_matched = kwargs.get('protocol_matched', None)
        self.source_matched = kwargs.get('source_matched', None)
        self.source_port_matched = kwargs.get('source_port_matched', None)
        self.destination_matched = kwargs.get('destination_matched', None)
        self.destination_port_matched = kwargs.get('destination_port_matched', None)
