# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class VirtualNetworkGatewayConnection(Resource):
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource Identifier.
    :type id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param authorization_key: The authorizationKey.
    :type authorization_key: str
    :param virtual_network_gateway1:
    :type virtual_network_gateway1:
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :param virtual_network_gateway2:
    :type virtual_network_gateway2:
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :param local_network_gateway2:
    :type local_network_gateway2:
     ~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway
    :param connection_type: Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Possible values
     include: 'IPsec', 'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
    :type connection_type: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionType
    :param routing_weight: The routing weight.
    :type routing_weight: int
    :param shared_key: The IPSec shared key.
    :type shared_key: str
    :param connection_status: Virtual network Gateway connection status.
     Possible values are 'Unknown', 'Connecting', 'Connected' and
     'NotConnected'. Possible values include: 'Unknown', 'Connecting',
     'Connected', 'NotConnected'
    :type connection_status: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionStatus
    :param egress_bytes_transferred: The egress bytes transferred in this
     connection.
    :type egress_bytes_transferred: long
    :param ingress_bytes_transferred: The ingress bytes transferred in this
     connection.
    :type ingress_bytes_transferred: long
    :param peer: The reference to peerings resource.
    :type peer: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :param enable_bgp: EnableBgp flag
    :type enable_bgp: bool
    :param resource_guid: The resource GUID property of the
     VirtualNetworkGatewayConnection resource.
    :type resource_guid: str
    :param provisioning_state: The provisioning state of the
     VirtualNetworkGatewayConnection resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :type provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated.
    :type etag: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'str'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'str'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'enable_bgp': {'key': 'properties.enableBgp', 'type': 'bool'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayConnection, self).__init__(**kwargs)
        self.authorization_key = kwargs.get('authorization_key', None)
        self.virtual_network_gateway1 = kwargs.get('virtual_network_gateway1', None)
        self.virtual_network_gateway2 = kwargs.get('virtual_network_gateway2', None)
        self.local_network_gateway2 = kwargs.get('local_network_gateway2', None)
        self.connection_type = kwargs.get('connection_type', None)
        self.routing_weight = kwargs.get('routing_weight', None)
        self.shared_key = kwargs.get('shared_key', None)
        self.connection_status = kwargs.get('connection_status', None)
        self.egress_bytes_transferred = kwargs.get('egress_bytes_transferred', None)
        self.ingress_bytes_transferred = kwargs.get('ingress_bytes_transferred', None)
        self.peer = kwargs.get('peer', None)
        self.enable_bgp = kwargs.get('enable_bgp', None)
        self.resource_guid = kwargs.get('resource_guid', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.etag = kwargs.get('etag', None)
