/*
 * Decompiled with CFR 0.152.
 */
package py4j.reflection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import py4j.reflection.TypeConverter;

public class TypeUtil {
    private static Set<String> numericTypes = new HashSet<String>();
    public static final int DISTANCE_FACTOR = 100;

    public static boolean isInteger(Class<?> clazz) {
        return clazz.equals(Integer.class) || clazz.equals(Integer.TYPE);
    }

    public static boolean isLong(Class<?> clazz) {
        return clazz.equals(Long.class) || clazz.equals(Long.TYPE);
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz.equals(Double.class) || clazz.equals(Double.TYPE);
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz.equals(Float.class) || clazz.equals(Float.TYPE);
    }

    public static boolean isShort(Class<?> clazz) {
        return clazz.equals(Short.class) || clazz.equals(Short.TYPE);
    }

    public static boolean isByte(Class<?> clazz) {
        return clazz.equals(Byte.class) || clazz.equals(Byte.TYPE);
    }

    public static boolean isNumeric(Class<?> clazz) {
        return numericTypes.contains(clazz.getName());
    }

    public static boolean isCharacter(Class<?> clazz) {
        return clazz.equals(Character.class) || clazz.equals(Character.TYPE);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE);
    }

    public static int getPoint(Class<?> clazz) {
        int point = -1;
        if (TypeUtil.isByte(clazz)) {
            point = 0;
        } else if (TypeUtil.isShort(clazz)) {
            point = 1;
        } else if (TypeUtil.isInteger(clazz)) {
            point = 2;
        } else if (TypeUtil.isLong(clazz)) {
            point = 3;
        }
        return point;
    }

    public static int getCost(Class<?> parent, Class<?> child) {
        return TypeUtil.getPoint(parent) - TypeUtil.getPoint(child);
    }

    public static int computeDistance(Class<?> parent, Class<?> child) {
        int distance = -1;
        if (parent.equals(child)) {
            distance = 0;
        }
        if (distance == -1) {
            distance = TypeUtil.computeSuperDistance(parent, child);
        }
        if (distance == -1) {
            distance = TypeUtil.computeInterfaceDistance(parent, child, new HashSet<String>(), Arrays.asList(child.getInterfaces()));
        }
        if (distance != -1) {
            distance *= 100;
        }
        return distance;
    }

    private static int computeSuperDistance(Class<?> parent, Class<?> child) {
        Class<?> superChild = child.getSuperclass();
        if (superChild == null) {
            return -1;
        }
        if (superChild.equals(parent)) {
            return 1;
        }
        int distance = TypeUtil.computeSuperDistance(parent, superChild);
        if (distance != -1) {
            return distance + 1;
        }
        return distance;
    }

    private static int computeInterfaceDistance(Class<?> parent, Class<?> child, Set<String> visitedInterfaces, List<Class<?>> interfacesToVisit) {
        int distance = -1;
        ArrayList nextInterfaces = new ArrayList();
        for (Class<?> clazz : interfacesToVisit) {
            if (parent.equals(clazz)) {
                distance = 1;
                break;
            }
            visitedInterfaces.add(clazz.getName());
            TypeUtil.getNextInterfaces(clazz, nextInterfaces, visitedInterfaces);
        }
        if (distance == -1 && child != null) {
            TypeUtil.getNextInterfaces(child.getSuperclass(), nextInterfaces, visitedInterfaces);
            int newDistance = TypeUtil.computeInterfaceDistance(parent, child.getSuperclass(), visitedInterfaces, nextInterfaces);
            if (newDistance != -1) {
                distance = newDistance + 1;
            }
        }
        return distance;
    }

    private static void getNextInterfaces(Class<?> clazz, List<Class<?>> nextInterfaces, Set<String> visitedInterfaces) {
        if (clazz != null) {
            for (Class<?> nextClazz : clazz.getInterfaces()) {
                if (visitedInterfaces.contains(nextClazz.getName())) continue;
                nextInterfaces.add(nextClazz);
            }
        }
    }

    public static int computeNumericConversion(Class<?> parent, Class<?> child, List<TypeConverter> converters) {
        int cost = -1;
        if (TypeUtil.isLong(parent) && !TypeUtil.isFloat(child) && !TypeUtil.isDouble(child)) {
            cost = TypeUtil.getCost(parent, child);
            converters.add(TypeConverter.NO_CONVERTER);
        } else if (TypeUtil.isInteger(parent) && (TypeUtil.isInteger(child) || TypeUtil.isShort(child) || TypeUtil.isByte(child))) {
            cost = TypeUtil.getCost(parent, child);
            converters.add(TypeConverter.NO_CONVERTER);
        } else if (TypeUtil.isShort(parent)) {
            if (TypeUtil.isShort(child) || TypeUtil.isByte(child)) {
                cost = TypeUtil.getCost(parent, child);
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isInteger(child)) {
                cost = 1;
                converters.add(TypeConverter.SHORT_CONVERTER);
            }
        } else if (TypeUtil.isByte(parent)) {
            if (TypeUtil.isByte(child)) {
                cost = 0;
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isInteger(child)) {
                cost = 2;
                converters.add(TypeConverter.BYTE_CONVERTER);
            }
        } else if (TypeUtil.isDouble(parent)) {
            if (TypeUtil.isDouble(child)) {
                cost = 0;
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isFloat(child)) {
                cost = 1;
                converters.add(TypeConverter.NO_CONVERTER);
            }
        } else if (TypeUtil.isFloat(parent)) {
            if (TypeUtil.isFloat(child)) {
                cost = 0;
                converters.add(TypeConverter.NO_CONVERTER);
            } else if (TypeUtil.isDouble(child)) {
                cost = 1;
                converters.add(TypeConverter.FLOAT_CONVERTER);
            }
        }
        return cost;
    }

    public static int computeCharacterConversion(Class<?> parent, Class<?> child, List<TypeConverter> converters) {
        int cost = -1;
        if (TypeUtil.isCharacter(child)) {
            cost = 0;
            converters.add(TypeConverter.NO_CONVERTER);
        } else if (CharSequence.class.isAssignableFrom(child)) {
            cost = 1;
            converters.add(TypeConverter.CHAR_CONVERTER);
        }
        return cost;
    }

    public static String getName(String name, boolean shortName) {
        if (!shortName) {
            return name;
        }
        int index = name.lastIndexOf(".");
        if (index >= 0 && index < name.length() + 1) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static String getPackage(String name) {
        int index = name.lastIndexOf(".");
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    public static String[] getNames(Class<?>[] classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getCanonicalName();
        }
        return names;
    }

    static {
        numericTypes.add(Long.TYPE.getName());
        numericTypes.add(Integer.TYPE.getName());
        numericTypes.add(Short.TYPE.getName());
        numericTypes.add(Byte.TYPE.getName());
        numericTypes.add(Double.TYPE.getName());
        numericTypes.add(Float.TYPE.getName());
        numericTypes.add(Long.class.getName());
        numericTypes.add(Integer.class.getName());
        numericTypes.add(Short.class.getName());
        numericTypes.add(Byte.class.getName());
        numericTypes.add(Double.class.getName());
        numericTypes.add(Float.class.getName());
    }
}

