# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class SensitivityLabel(ProxyResource):
    """A sensitivity label.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param label_name: The label name.
    :type label_name: str
    :param label_id: The label ID.
    :type label_id: str
    :param information_type: The information type.
    :type information_type: str
    :param information_type_id: The information type ID.
    :type information_type_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'label_name': {'key': 'properties.labelName', 'type': 'str'},
        'label_id': {'key': 'properties.labelId', 'type': 'str'},
        'information_type': {'key': 'properties.informationType', 'type': 'str'},
        'information_type_id': {'key': 'properties.informationTypeId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SensitivityLabel, self).__init__(**kwargs)
        self.label_name = kwargs.get('label_name', None)
        self.label_id = kwargs.get('label_id', None)
        self.information_type = kwargs.get('information_type', None)
        self.information_type_id = kwargs.get('information_type_id', None)
