# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MetricDefinition(Model):
    """A database metric definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name information for the metric.
    :vartype name: ~azure.mgmt.sql.models.MetricName
    :ivar primary_aggregation_type: The primary aggregation type defining how
     metric values are displayed. Possible values include: 'None', 'Average',
     'Count', 'Minimum', 'Maximum', 'Total'
    :vartype primary_aggregation_type: str or
     ~azure.mgmt.sql.models.PrimaryAggregationType
    :ivar resource_uri: The resource uri of the database.
    :vartype resource_uri: str
    :ivar unit: The unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond'
    :vartype unit: str or ~azure.mgmt.sql.models.UnitDefinitionType
    :ivar metric_availabilities: The list of database metric availabilities
     for the metric.
    :vartype metric_availabilities:
     list[~azure.mgmt.sql.models.MetricAvailability]
    """

    _validation = {
        'name': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'resource_uri': {'readonly': True},
        'unit': {'readonly': True},
        'metric_availabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
    }

    def __init__(self, **kwargs) -> None:
        super(MetricDefinition, self).__init__(**kwargs)
        self.name = None
        self.primary_aggregation_type = None
        self.resource_uri = None
        self.unit = None
        self.metric_availabilities = None
