# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MaxSizeCapability(Model):
    """The maximum size capability.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: The maximum size limit (see 'unit' for the units).
    :vartype limit: int
    :ivar unit: The units that the limit is expressed in. Possible values
     include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes'
    :vartype unit: str or ~azure.mgmt.sql.models.MaxSizeUnit
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'int'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(MaxSizeCapability, self).__init__(**kwargs)
        self.limit = None
        self.unit = None
