# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AADObject(Model):
    """
    Active Directory object information

    :param str object_id: Gets or sets object Id
    :param str object_type: Gets or sets object type
    :param str display_name: Gets or sets object display name
    :param str user_principal_name: Gets or sets principal name
    :param str mail: Gets or sets mail
    :param bool mail_enabled: Gets or sets MailEnabled field
    :param bool security_enabled: Gets or sets SecurityEnabled field
    :param str sign_in_name: Gets or sets signIn name
    :param list service_principal_names: Gets or sets the list of service
     principal names.
    :param str user_type: Gets or sets the user type
    """

    _required = []

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'user_principal_name': {'key': 'userPrincipalName', 'type': 'str'},
        'mail': {'key': 'mail', 'type': 'str'},
        'mail_enabled': {'key': 'mailEnabled', 'type': 'bool'},
        'security_enabled': {'key': 'securityEnabled', 'type': 'bool'},
        'sign_in_name': {'key': 'signInName', 'type': 'str'},
        'service_principal_names': {'key': 'servicePrincipalNames', 'type': '[str]'},
        'user_type': {'key': 'userType', 'type': 'str'},
    }

    def __init__(self, object_id=None, object_type=None, display_name=None, user_principal_name=None, mail=None, mail_enabled=None, security_enabled=None, sign_in_name=None, service_principal_names=None, user_type=None):
        self.object_id = object_id
        self.object_type = object_type
        self.display_name = display_name
        self.user_principal_name = user_principal_name
        self.mail = mail
        self.mail_enabled = mail_enabled
        self.security_enabled = security_enabled
        self.sign_in_name = sign_in_name
        self.service_principal_names = service_principal_names
        self.user_type = user_type
