# Copyright 2020 StrongDM Inc
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Code generated by protogen. DO NOT EDIT.

import grpc
from . import plumbing
from . import models
from .options_pb2 import *
from .options_pb2_grpc import *
from .spec_pb2 import *
from .spec_pb2_grpc import *
from .tags_pb2 import *
from .tags_pb2_grpc import *
from .access_requests_pb2 import *
from .access_requests_pb2_grpc import *
from .access_request_events_history_pb2 import *
from .access_request_events_history_pb2_grpc import *
from .access_requests_history_pb2 import *
from .access_requests_history_pb2_grpc import *
from .account_attachments_pb2 import *
from .account_attachments_pb2_grpc import *
from .account_attachments_history_pb2 import *
from .account_attachments_history_pb2_grpc import *
from .account_grants_pb2 import *
from .account_grants_pb2_grpc import *
from .account_grants_history_pb2 import *
from .account_grants_history_pb2_grpc import *
from .account_permissions_pb2 import *
from .account_permissions_pb2_grpc import *
from .account_resources_pb2 import *
from .account_resources_pb2_grpc import *
from .account_resources_history_pb2 import *
from .account_resources_history_pb2_grpc import *
from .accounts_pb2 import *
from .accounts_pb2_grpc import *
from .accounts_history_pb2 import *
from .accounts_history_pb2_grpc import *
from .activities_pb2 import *
from .activities_pb2_grpc import *
from .control_panel_pb2 import *
from .control_panel_pb2_grpc import *
from .drivers_pb2 import *
from .drivers_pb2_grpc import *
from .nodes_pb2 import *
from .nodes_pb2_grpc import *
from .nodes_history_pb2 import *
from .nodes_history_pb2_grpc import *
from .organization_history_pb2 import *
from .organization_history_pb2_grpc import *
from .peering_group_nodes_pb2 import *
from .peering_group_nodes_pb2_grpc import *
from .peering_group_peers_pb2 import *
from .peering_group_peers_pb2_grpc import *
from .peering_group_resources_pb2 import *
from .peering_group_resources_pb2_grpc import *
from .peering_groups_pb2 import *
from .peering_groups_pb2_grpc import *
from .queries_pb2 import *
from .queries_pb2_grpc import *
from .remote_identities_pb2 import *
from .remote_identities_pb2_grpc import *
from .remote_identities_history_pb2 import *
from .remote_identities_history_pb2_grpc import *
from .remote_identity_groups_pb2 import *
from .remote_identity_groups_pb2_grpc import *
from .remote_identity_groups_history_pb2 import *
from .remote_identity_groups_history_pb2_grpc import *
from .replays_pb2 import *
from .replays_pb2_grpc import *
from .resources_pb2 import *
from .resources_pb2_grpc import *
from .resources_history_pb2 import *
from .resources_history_pb2_grpc import *
from .role_resources_pb2 import *
from .role_resources_pb2_grpc import *
from .role_resources_history_pb2 import *
from .role_resources_history_pb2_grpc import *
from .roles_pb2 import *
from .roles_pb2_grpc import *
from .roles_history_pb2 import *
from .roles_history_pb2_grpc import *
from .secret_store_types_pb2 import *
from .secret_store_types_pb2_grpc import *
from .secret_stores_pb2 import *
from .secret_stores_pb2_grpc import *
from .secret_stores_history_pb2 import *
from .secret_stores_history_pb2_grpc import *
from .workflow_approvers_pb2 import *
from .workflow_approvers_pb2_grpc import *
from .workflow_approvers_history_pb2 import *
from .workflow_approvers_history_pb2_grpc import *
from .workflow_assignments_pb2 import *
from .workflow_assignments_pb2_grpc import *
from .workflow_assignments_history_pb2 import *
from .workflow_assignments_history_pb2_grpc import *
from .workflow_roles_pb2 import *
from .workflow_roles_pb2_grpc import *
from .workflow_roles_history_pb2 import *
from .workflow_roles_history_pb2_grpc import *
from .workflows_pb2 import *
from .workflows_pb2_grpc import *
from .workflows_history_pb2 import *
from .workflows_history_pb2_grpc import *
import warnings
import functools


def deprecated(func):
    """This is a decorator which can be used to mark functions
    as deprecated. It will result in a warning being emitted
    when the function is used."""
    @functools.wraps(func)
    def new_func(*args, **kwargs):
        warnings.warn("Call to deprecated function {}.".format(func.__name__),
                      category=DeprecationWarning,
                      stacklevel=2)
        return func(*args, **kwargs)

    return new_func


class AccessRequests:
    '''
     AccessRequests are requests for access to a resource that may match a Workflow.
    See `strongdm.models.AccessRequest`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccessRequestsStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing access requests.
        '''
        req = AccessRequestListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccessRequests.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.access_requests:
                    yield plumbing.convert_access_request_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotAccessRequests:
    '''
    SnapshotAccessRequests exposes the read only methods of the AccessRequests
    service for historical queries.
    '''
    def __init__(self, access_requests):
        self.access_requests = access_requests

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing access requests.
        '''
        return self.access_requests.list(filter, *args, timeout=timeout)


class AccessRequestEventsHistory:
    '''
     AccessRequestEventsHistory provides records of all changes to the state of an AccessRequest.
    See `strongdm.models.AccessRequestEventHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccessRequestEventsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccessRequestEventHistory records matching a given set of criteria.
        '''
        req = AccessRequestEventHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccessRequestEventsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_access_request_event_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class AccessRequestsHistory:
    '''
     AccessRequestsHistory provides records of all changes to the state of an AccessRequest.
    See `strongdm.models.AccessRequestHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccessRequestsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccessRequestHistory records matching a given set of criteria.
        '''
        req = AccessRequestHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccessRequestsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_access_request_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class AccountAttachments:
    '''
     AccountAttachments assign an account to a role.
    See `strongdm.models.AccountAttachment`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountAttachmentsStub(channel)

    def create(self, account_attachment, timeout=None):
        '''
         Create registers a new AccountAttachment.
        '''
        req = AccountAttachmentCreateRequest()

        if account_attachment is not None:
            req.account_attachment.CopyFrom(
                plumbing.convert_account_attachment_to_plumbing(
                    account_attachment))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'AccountAttachments.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountAttachmentCreateResponse()
        resp.account_attachment = plumbing.convert_account_attachment_to_porcelain(
            plumbing_response.account_attachment)
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one AccountAttachment by ID.
        '''
        req = AccountAttachmentGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('AccountAttachments.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountAttachmentGetResponse()
        resp.account_attachment = plumbing.convert_account_attachment_to_porcelain(
            plumbing_response.account_attachment)
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a AccountAttachment by ID.
        '''
        req = AccountAttachmentDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'AccountAttachments.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountAttachmentDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountAttachments matching a given set of criteria.
        '''
        req = AccountAttachmentListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountAttachments.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.account_attachments:
                    yield plumbing.convert_account_attachment_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotAccountAttachments:
    '''
    SnapshotAccountAttachments exposes the read only methods of the AccountAttachments
    service for historical queries.
    '''
    def __init__(self, account_attachments):
        self.account_attachments = account_attachments

    def get(self, id, timeout=None):
        '''
         Get reads one AccountAttachment by ID.
        '''
        return self.account_attachments.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountAttachments matching a given set of criteria.
        '''
        return self.account_attachments.list(filter, *args, timeout=timeout)


class AccountAttachmentsHistory:
    '''
     AccountAttachmentsHistory records all changes to the state of an AccountAttachment.
    See `strongdm.models.AccountAttachmentHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountAttachmentsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountAttachmentHistory records matching a given set of criteria.
        '''
        req = AccountAttachmentHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountAttachmentsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_account_attachment_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class AccountGrants:
    '''
     AccountGrants assign a resource directly to an account, giving the account the permission to connect to that resource.
    See `strongdm.models.AccountGrant`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountGrantsStub(channel)

    def create(self, account_grant, timeout=None):
        '''
         Create registers a new AccountGrant.
        '''
        req = AccountGrantCreateRequest()

        if account_grant is not None:
            req.account_grant.CopyFrom(
                plumbing.convert_account_grant_to_plumbing(account_grant))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('AccountGrants.Create',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGrantCreateResponse()
        resp.account_grant = plumbing.convert_account_grant_to_porcelain(
            plumbing_response.account_grant)
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one AccountGrant by ID.
        '''
        req = AccountGrantGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('AccountGrants.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGrantGetResponse()
        resp.account_grant = plumbing.convert_account_grant_to_porcelain(
            plumbing_response.account_grant)
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a AccountGrant by ID.
        '''
        req = AccountGrantDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('AccountGrants.Delete',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGrantDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountGrants matching a given set of criteria.
        '''
        req = AccountGrantListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountGrants.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.account_grants:
                    yield plumbing.convert_account_grant_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotAccountGrants:
    '''
    SnapshotAccountGrants exposes the read only methods of the AccountGrants
    service for historical queries.
    '''
    def __init__(self, account_grants):
        self.account_grants = account_grants

    def get(self, id, timeout=None):
        '''
         Get reads one AccountGrant by ID.
        '''
        return self.account_grants.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountGrants matching a given set of criteria.
        '''
        return self.account_grants.list(filter, *args, timeout=timeout)


class AccountGrantsHistory:
    '''
     AccountGrantsHistory records all changes to the state of an AccountGrant.
    See `strongdm.models.AccountGrantHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountGrantsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountGrantHistory records matching a given set of criteria.
        '''
        req = AccountGrantHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountGrantsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_account_grant_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class AccountPermissions:
    '''
     AccountPermissions records the granular permissions accounts have, allowing them to execute
     relevant commands via StrongDM's APIs.
    See `strongdm.models.AccountPermission`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountPermissionsStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Permission records matching a given set of criteria.
        '''
        req = AccountPermissionListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountPermissions.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.permissions:
                    yield plumbing.convert_account_permission_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotAccountPermissions:
    '''
    SnapshotAccountPermissions exposes the read only methods of the AccountPermissions
    service for historical queries.
    '''
    def __init__(self, account_permissions):
        self.account_permissions = account_permissions

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Permission records matching a given set of criteria.
        '''
        return self.account_permissions.list(filter, *args, timeout=timeout)


class AccountResources:
    '''
     AccountResources enumerates the resources to which accounts have access.
     The AccountResources service is read-only.
    See `strongdm.models.AccountResource`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountResourcesStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountResource records matching a given set of criteria.
        '''
        req = AccountResourceListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountResources.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.account_resources:
                    yield plumbing.convert_account_resource_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotAccountResources:
    '''
    SnapshotAccountResources exposes the read only methods of the AccountResources
    service for historical queries.
    '''
    def __init__(self, account_resources):
        self.account_resources = account_resources

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountResource records matching a given set of criteria.
        '''
        return self.account_resources.list(filter, *args, timeout=timeout)


class AccountResourcesHistory:
    '''
     AccountResourcesHistory records all changes to the state of a AccountResource.
    See `strongdm.models.AccountResourceHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountResourcesHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountResourceHistory records matching a given set of criteria.
        '''
        req = AccountResourceHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountResourcesHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_account_resource_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Accounts:
    '''
     Accounts are users that have access to strongDM. There are two types of accounts:
     1. **Users:** humans who are authenticated through username and password or SSO.
     2. **Service Accounts:** machines that are authenticated using a service token.
    See:
    `strongdm.models.Service`
    `strongdm.models.User`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountsStub(channel)

    def create(self, account, timeout=None):
        '''
         Create registers a new Account.
        '''
        req = AccountCreateRequest()

        if account is not None:
            req.account.CopyFrom(plumbing.convert_account_to_plumbing(account))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountCreateResponse()
        resp.account = plumbing.convert_account_to_porcelain(
            plumbing_response.account)
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.token = (plumbing_response.token)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Account by ID.
        '''
        req = AccountGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountGetResponse()
        resp.account = plumbing.convert_account_to_porcelain(
            plumbing_response.account)
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def update(self, account, timeout=None):
        '''
         Update replaces all the fields of an Account by ID.
        '''
        req = AccountUpdateRequest()

        if account is not None:
            req.account.CopyFrom(plumbing.convert_account_to_plumbing(account))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountUpdateResponse()
        resp.account = plumbing.convert_account_to_porcelain(
            plumbing_response.account)
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes an Account by ID.
        '''
        req = AccountDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Accounts.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.AccountDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Accounts matching a given set of criteria.
        '''
        req = AccountListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Accounts.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.accounts:
                    yield plumbing.convert_account_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotAccounts:
    '''
    SnapshotAccounts exposes the read only methods of the Accounts
    service for historical queries.
    '''
    def __init__(self, accounts):
        self.accounts = accounts

    def get(self, id, timeout=None):
        '''
         Get reads one Account by ID.
        '''
        return self.accounts.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Accounts matching a given set of criteria.
        '''
        return self.accounts.list(filter, *args, timeout=timeout)


class AccountsHistory:
    '''
     AccountsHistory records all changes to the state of an Account.
    See `strongdm.models.AccountHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = AccountsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of AccountHistory records matching a given set of criteria.
        '''
        req = AccountHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'AccountsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_account_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Activities:
    '''
     An Activity is a record of an action taken against a strongDM deployment, e.g.
     a user creation, resource deletion, sso configuration change, etc. The Activities
     service is read-only.
    See `strongdm.models.Activity`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = ActivitiesStub(channel)

    def get(self, id, timeout=None):
        '''
         Get reads one Activity by ID.
        '''
        req = ActivityGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Activities.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ActivityGetResponse()
        resp.activity = plumbing.convert_activity_to_porcelain(
            plumbing_response.activity)
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Activities matching a given set of criteria.
         The 'before' and 'after' filters can be used to control the time
         range of the output activities. If not provided, one week of back
         of activities will be returned.
        '''
        req = ActivityListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'Activities.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.activities:
                    yield plumbing.convert_activity_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class ControlPanel:
    '''
     ControlPanel contains all administrative controls.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = ControlPanelStub(channel)

    def get_sshca_public_key(self, timeout=None):
        '''
         GetSSHCAPublicKey retrieves the SSH CA public key.
        '''
        req = ControlPanelGetSSHCAPublicKeyRequest()

        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.GetSSHCAPublicKey(
                    req,
                    metadata=self.parent.get_metadata(
                        'ControlPanel.GetSSHCAPublicKey', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ControlPanelGetSSHCAPublicKeyResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.public_key = (plumbing_response.public_key)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get_rdpca_public_key(self, timeout=None):
        '''
         GetRDPCAPublicKey retrieves the RDP CA public key.
        '''
        req = ControlPanelGetRDPCAPublicKeyRequest()

        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.GetRDPCAPublicKey(
                    req,
                    metadata=self.parent.get_metadata(
                        'ControlPanel.GetRDPCAPublicKey', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ControlPanelGetRDPCAPublicKeyResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.public_key = (plumbing_response.public_key)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def verify_jwt(self, token, timeout=None):
        '''
         VerifyJWT reports whether the given JWT token (x-sdm-token) is valid.
        '''
        req = ControlPanelVerifyJWTRequest()

        req.token = (token)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.VerifyJWT(
                    req,
                    metadata=self.parent.get_metadata('ControlPanel.VerifyJWT',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ControlPanelVerifyJWTResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.valid = (plumbing_response.valid)
        return resp


class Nodes:
    '''
     Nodes make up the strongDM network, and allow your users to connect securely to your resources. There are two types of nodes:
     - **Gateways** are the entry points into network. They listen for connection from the strongDM client, and provide access to databases and servers.
     - **Relays** are used to extend the strongDM network into segmented subnets. They provide access to databases and servers but do not listen for incoming connections.
    See:
    `strongdm.models.Gateway`
    `strongdm.models.Relay`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = NodesStub(channel)

    def create(self, node, timeout=None):
        '''
         Create registers a new Node.
        '''
        req = NodeCreateRequest()

        if node is not None:
            req.node.CopyFrom(plumbing.convert_node_to_plumbing(node))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.node = plumbing.convert_node_to_porcelain(plumbing_response.node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.token = (plumbing_response.token)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Node by ID.
        '''
        req = NodeGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.node = plumbing.convert_node_to_porcelain(plumbing_response.node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def update(self, node, timeout=None):
        '''
         Update replaces all the fields of a Node by ID.
        '''
        req = NodeUpdateRequest()

        if node is not None:
            req.node.CopyFrom(plumbing.convert_node_to_plumbing(node))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.node = plumbing.convert_node_to_porcelain(plumbing_response.node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a Node by ID.
        '''
        req = NodeDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Nodes.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.NodeDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Nodes matching a given set of criteria.
        '''
        req = NodeListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Nodes.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.nodes:
                    yield plumbing.convert_node_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotNodes:
    '''
    SnapshotNodes exposes the read only methods of the Nodes
    service for historical queries.
    '''
    def __init__(self, nodes):
        self.nodes = nodes

    def get(self, id, timeout=None):
        '''
         Get reads one Node by ID.
        '''
        return self.nodes.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Nodes matching a given set of criteria.
        '''
        return self.nodes.list(filter, *args, timeout=timeout)


class NodesHistory:
    '''
     NodesHistory records all changes to the state of a Node.
    See `strongdm.models.NodeHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = NodesHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of NodeHistory records matching a given set of criteria.
        '''
        req = NodeHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'NodesHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_node_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class OrganizationHistory:
    '''
     OrganizationHistory records all changes to the state of an Organization.
    See `strongdm.models.OrganizationHistoryRecord`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = OrganizationHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of OrganizationHistory records matching a given set of criteria.
        '''
        req = OrganizationHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'OrganizationHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_organization_history_record_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class PeeringGroupNodes:
    '''
     PeeringGroupNodes provides the building blocks necessary to obtain attach a node to a peering group.
    See `strongdm.models.PeeringGroupNode`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = PeeringGroupNodesStub(channel)

    def create(self, peering_group_node, timeout=None):
        '''
         Create attaches a Node to a PeeringGroup
        '''
        req = PeeringGroupNodeCreateRequest()

        if peering_group_node is not None:
            req.peering_group_node.CopyFrom(
                plumbing.convert_peering_group_node_to_plumbing(
                    peering_group_node))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'PeeringGroupNodes.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupNodeCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group_node = plumbing.convert_peering_group_node_to_porcelain(
            plumbing_response.peering_group_node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete detaches a Node to a PeeringGroup.
        '''
        req = PeeringGroupNodeDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'PeeringGroupNodes.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupNodeDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads the information of one peering group to node attachment.
        '''
        req = PeeringGroupNodeGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('PeeringGroupNodes.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupNodeGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group_node = plumbing.convert_peering_group_node_to_porcelain(
            plumbing_response.peering_group_node)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of peering group node attachments.
        '''
        req = PeeringGroupNodeListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'PeeringGroupNodes.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.peering_group_nodes:
                    yield plumbing.convert_peering_group_node_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotPeeringGroupNodes:
    '''
    SnapshotPeeringGroupNodes exposes the read only methods of the PeeringGroupNodes
    service for historical queries.
    '''
    def __init__(self, peering_group_nodes):
        self.peering_group_nodes = peering_group_nodes

    def get(self, id, timeout=None):
        '''
         Get reads the information of one peering group to node attachment.
        '''
        return self.peering_group_nodes.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of peering group node attachments.
        '''
        return self.peering_group_nodes.list(filter, *args, timeout=timeout)


class PeeringGroupPeers:
    '''
     PeeringGroupPeers provides the building blocks necessary to link two peering groups.
    See `strongdm.models.PeeringGroupPeer`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = PeeringGroupPeersStub(channel)

    def create(self, peering_group_peer, timeout=None):
        '''
         Create links two peering groups.
        '''
        req = PeeringGroupPeerCreateRequest()

        if peering_group_peer is not None:
            req.peering_group_peer.CopyFrom(
                plumbing.convert_peering_group_peer_to_plumbing(
                    peering_group_peer))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'PeeringGroupPeers.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupPeerCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group_peer = plumbing.convert_peering_group_peer_to_porcelain(
            plumbing_response.peering_group_peer)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete unlinks two peering groups.
        '''
        req = PeeringGroupPeerDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'PeeringGroupPeers.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupPeerDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads the information of one peering group link.
        '''
        req = PeeringGroupPeerGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('PeeringGroupPeers.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupPeerGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group_peer = plumbing.convert_peering_group_peer_to_porcelain(
            plumbing_response.peering_group_peer)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of peering group links.
        '''
        req = PeeringGroupPeerListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'PeeringGroupPeers.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.peering_group_peers:
                    yield plumbing.convert_peering_group_peer_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotPeeringGroupPeers:
    '''
    SnapshotPeeringGroupPeers exposes the read only methods of the PeeringGroupPeers
    service for historical queries.
    '''
    def __init__(self, peering_group_peers):
        self.peering_group_peers = peering_group_peers

    def get(self, id, timeout=None):
        '''
         Get reads the information of one peering group link.
        '''
        return self.peering_group_peers.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of peering group links.
        '''
        return self.peering_group_peers.list(filter, *args, timeout=timeout)


class PeeringGroupResources:
    '''
     PeeringGroupResources provides the building blocks necessary to obtain attach a resource to a peering group.
    See `strongdm.models.PeeringGroupResource`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = PeeringGroupResourcesStub(channel)

    def create(self, peering_group_resource, timeout=None):
        '''
         Create attaches a Resource to a PeeringGroup
        '''
        req = PeeringGroupResourceCreateRequest()

        if peering_group_resource is not None:
            req.peering_group_resource.CopyFrom(
                plumbing.convert_peering_group_resource_to_plumbing(
                    peering_group_resource))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'PeeringGroupResources.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupResourceCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group_resource = plumbing.convert_peering_group_resource_to_porcelain(
            plumbing_response.peering_group_resource)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete detaches a Resource to a PeeringGroup
        '''
        req = PeeringGroupResourceDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'PeeringGroupResources.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupResourceDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads the information of one peering group to resource attachment.
        '''
        req = PeeringGroupResourceGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata(
                        'PeeringGroupResources.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupResourceGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group_resource = plumbing.convert_peering_group_resource_to_porcelain(
            plumbing_response.peering_group_resource)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of peering group resource attachments.
        '''
        req = PeeringGroupResourceListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'PeeringGroupResources.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.peering_group_resources:
                    yield plumbing.convert_peering_group_resource_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotPeeringGroupResources:
    '''
    SnapshotPeeringGroupResources exposes the read only methods of the PeeringGroupResources
    service for historical queries.
    '''
    def __init__(self, peering_group_resources):
        self.peering_group_resources = peering_group_resources

    def get(self, id, timeout=None):
        '''
         Get reads the information of one peering group to resource attachment.
        '''
        return self.peering_group_resources.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of peering group resource attachments.
        '''
        return self.peering_group_resources.list(filter,
                                                 *args,
                                                 timeout=timeout)


class PeeringGroups:
    '''
     PeeringGroups provides the building blocks necessary to obtain explicit network topology and routing.
    See `strongdm.models.PeeringGroup`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = PeeringGroupsStub(channel)

    def create(self, peering_group, timeout=None):
        '''
         Create registers a new PeeringGroup.
        '''
        req = PeeringGroupCreateRequest()

        if peering_group is not None:
            req.peering_group.CopyFrom(
                plumbing.convert_peering_group_to_plumbing(peering_group))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('PeeringGroups.Create',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group = plumbing.convert_peering_group_to_porcelain(
            plumbing_response.peering_group)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a PeeringGroup by ID.
        '''
        req = PeeringGroupDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('PeeringGroups.Delete',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one PeeringGroup by ID. It will load all its dependencies.
        '''
        req = PeeringGroupGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('PeeringGroups.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.PeeringGroupGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.peering_group = plumbing.convert_peering_group_to_porcelain(
            plumbing_response.peering_group)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Peering Groups.
        '''
        req = PeeringGroupListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'PeeringGroups.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.peering_groups:
                    yield plumbing.convert_peering_group_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotPeeringGroups:
    '''
    SnapshotPeeringGroups exposes the read only methods of the PeeringGroups
    service for historical queries.
    '''
    def __init__(self, peering_groups):
        self.peering_groups = peering_groups

    def get(self, id, timeout=None):
        '''
         Get reads one PeeringGroup by ID. It will load all its dependencies.
        '''
        return self.peering_groups.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Peering Groups.
        '''
        return self.peering_groups.list(filter, *args, timeout=timeout)


class Queries:
    '''
     A Query is a record of a single client request to a resource, such as a SQL query.
     Long-running SSH, RDP, or Kubernetes interactive sessions also count as queries.
     The Queries service is read-only.
    See `strongdm.models.Query`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = QueriesStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Queries matching a given set of criteria.
        '''
        req = QueryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Queries.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.queries:
                    yield plumbing.convert_query_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class RemoteIdentities:
    '''
     RemoteIdentities assign a resource directly to an account, giving the account the permission to connect to that resource.
    See `strongdm.models.RemoteIdentity`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RemoteIdentitiesStub(channel)

    def create(self, remote_identity, timeout=None):
        '''
         Create registers a new RemoteIdentity.
        '''
        req = RemoteIdentityCreateRequest()

        if remote_identity is not None:
            req.remote_identity.CopyFrom(
                plumbing.convert_remote_identity_to_plumbing(remote_identity))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentities.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity = plumbing.convert_remote_identity_to_porcelain(
            plumbing_response.remote_identity)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one RemoteIdentity by ID.
        '''
        req = RemoteIdentityGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('RemoteIdentities.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity = plumbing.convert_remote_identity_to_porcelain(
            plumbing_response.remote_identity)
        return resp

    def update(self, remote_identity, timeout=None):
        '''
         Update replaces all the fields of a RemoteIdentity by ID.
        '''
        req = RemoteIdentityUpdateRequest()

        if remote_identity is not None:
            req.remote_identity.CopyFrom(
                plumbing.convert_remote_identity_to_plumbing(remote_identity))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentities.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity = plumbing.convert_remote_identity_to_porcelain(
            plumbing_response.remote_identity)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a RemoteIdentity by ID.
        '''
        req = RemoteIdentityDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentities.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentities matching a given set of criteria.
        '''
        req = RemoteIdentityListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RemoteIdentities.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.remote_identities:
                    yield plumbing.convert_remote_identity_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotRemoteIdentities:
    '''
    SnapshotRemoteIdentities exposes the read only methods of the RemoteIdentities
    service for historical queries.
    '''
    def __init__(self, remote_identities):
        self.remote_identities = remote_identities

    def get(self, id, timeout=None):
        '''
         Get reads one RemoteIdentity by ID.
        '''
        return self.remote_identities.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentities matching a given set of criteria.
        '''
        return self.remote_identities.list(filter, *args, timeout=timeout)


class RemoteIdentitiesHistory:
    '''
     RemoteIdentitiesHistory records all changes to the state of a RemoteIdentity.
    See `strongdm.models.RemoteIdentityHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RemoteIdentitiesHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentityHistory records matching a given set of criteria.
        '''
        req = RemoteIdentityHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RemoteIdentitiesHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_remote_identity_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class RemoteIdentityGroups:
    '''
     A RemoteIdentityGroup is a named grouping of Remote Identities for Accounts.
     An Account's relationship to a RemoteIdentityGroup is defined via RemoteIdentity objects.
    See `strongdm.models.RemoteIdentityGroup`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RemoteIdentityGroupsStub(channel)

    def get(self, id, timeout=None):
        '''
         Get reads one RemoteIdentityGroup by ID.
        '''
        req = RemoteIdentityGroupGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata(
                        'RemoteIdentityGroups.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RemoteIdentityGroupGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.remote_identity_group = plumbing.convert_remote_identity_group_to_porcelain(
            plumbing_response.remote_identity_group)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentityGroups matching a given set of criteria.
        '''
        req = RemoteIdentityGroupListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RemoteIdentityGroups.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.remote_identity_groups:
                    yield plumbing.convert_remote_identity_group_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotRemoteIdentityGroups:
    '''
    SnapshotRemoteIdentityGroups exposes the read only methods of the RemoteIdentityGroups
    service for historical queries.
    '''
    def __init__(self, remote_identity_groups):
        self.remote_identity_groups = remote_identity_groups

    def get(self, id, timeout=None):
        '''
         Get reads one RemoteIdentityGroup by ID.
        '''
        return self.remote_identity_groups.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentityGroups matching a given set of criteria.
        '''
        return self.remote_identity_groups.list(filter, *args, timeout=timeout)


class RemoteIdentityGroupsHistory:
    '''
     RemoteIdentityGroupsHistory records all changes to the state of a RemoteIdentityGroup.
    See `strongdm.models.RemoteIdentityGroupHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RemoteIdentityGroupsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RemoteIdentityGroupHistory records matching a given set of criteria.
        '''
        req = RemoteIdentityGroupHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RemoteIdentityGroupsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_remote_identity_group_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Replays:
    '''
     A Replay captures the data transferred over a long-running SSH, RDP, or Kubernetes interactive session
     (otherwise referred to as a query). The Replays service is read-only.
    See `strongdm.models.ReplayChunk`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = ReplaysStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of ReplayChunks for the Query ID specified by the filter criteria.
        '''
        req = ReplayListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Replays.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.chunks:
                    yield plumbing.convert_replay_chunk_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Resources:
    '''
     Resources are databases, servers, clusters, websites, or clouds that strongDM
     delegates access to.
    See:
    `strongdm.models.AKS`
    `strongdm.models.AKSBasicAuth`
    `strongdm.models.AKSServiceAccount`
    `strongdm.models.AKSServiceAccountUserImpersonation`
    `strongdm.models.AKSUserImpersonation`
    `strongdm.models.AmazonEKS`
    `strongdm.models.AmazonEKSInstanceProfile`
    `strongdm.models.AmazonEKSInstanceProfileUserImpersonation`
    `strongdm.models.AmazonEKSUserImpersonation`
    `strongdm.models.AmazonES`
    `strongdm.models.AmazonMQAMQP091`
    `strongdm.models.Athena`
    `strongdm.models.AuroraMysql`
    `strongdm.models.AuroraPostgres`
    `strongdm.models.AuroraPostgresIAM`
    `strongdm.models.AWS`
    `strongdm.models.AWSConsole`
    `strongdm.models.AWSConsoleStaticKeyPair`
    `strongdm.models.Azure`
    `strongdm.models.AzureCertificate`
    `strongdm.models.AzureMysql`
    `strongdm.models.AzurePostgres`
    `strongdm.models.AzurePostgresManagedIdentity`
    `strongdm.models.BigQuery`
    `strongdm.models.Cassandra`
    `strongdm.models.Citus`
    `strongdm.models.Clustrix`
    `strongdm.models.Cockroach`
    `strongdm.models.DB2I`
    `strongdm.models.DB2LUW`
    `strongdm.models.DocumentDBHost`
    `strongdm.models.DocumentDBReplicaSet`
    `strongdm.models.Druid`
    `strongdm.models.DynamoDB`
    `strongdm.models.Elastic`
    `strongdm.models.ElasticacheRedis`
    `strongdm.models.GCP`
    `strongdm.models.GoogleGKE`
    `strongdm.models.GoogleGKEUserImpersonation`
    `strongdm.models.Greenplum`
    `strongdm.models.HTTPAuth`
    `strongdm.models.HTTPBasicAuth`
    `strongdm.models.HTTPNoAuth`
    `strongdm.models.Kubernetes`
    `strongdm.models.KubernetesBasicAuth`
    `strongdm.models.KubernetesServiceAccount`
    `strongdm.models.KubernetesServiceAccountUserImpersonation`
    `strongdm.models.KubernetesUserImpersonation`
    `strongdm.models.Maria`
    `strongdm.models.Memcached`
    `strongdm.models.Memsql`
    `strongdm.models.MongoHost`
    `strongdm.models.MongoLegacyHost`
    `strongdm.models.MongoLegacyReplicaset`
    `strongdm.models.MongoReplicaSet`
    `strongdm.models.MongoShardedCluster`
    `strongdm.models.MTLSMysql`
    `strongdm.models.MTLSPostgres`
    `strongdm.models.Mysql`
    `strongdm.models.Neptune`
    `strongdm.models.NeptuneIAM`
    `strongdm.models.Oracle`
    `strongdm.models.Postgres`
    `strongdm.models.Presto`
    `strongdm.models.RabbitMQAMQP091`
    `strongdm.models.RawTCP`
    `strongdm.models.RDP`
    `strongdm.models.RDSPostgresIAM`
    `strongdm.models.Redis`
    `strongdm.models.Redshift`
    `strongdm.models.SingleStore`
    `strongdm.models.Snowflake`
    `strongdm.models.Snowsight`
    `strongdm.models.SQLServer`
    `strongdm.models.SQLServerAzureAD`
    `strongdm.models.SQLServerKerberosAD`
    `strongdm.models.SSH`
    `strongdm.models.SSHCert`
    `strongdm.models.SSHCustomerKey`
    `strongdm.models.Sybase`
    `strongdm.models.SybaseIQ`
    `strongdm.models.Teradata`
    `strongdm.models.Trino`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = ResourcesStub(channel)

    def enumerate_tags(self, filter, *args, timeout=None):
        '''
         EnumerateTags gets a list of the filter matching tags.
        '''
        req = EnumerateTagsRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.EnumerateTags(
                        req,
                        metadata=svc.parent.get_metadata(
                            'Resources.EnumerateTags', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.matches:
                    yield plumbing.convert_tag_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)

    def create(self, resource, timeout=None):
        '''
         Create registers a new Resource.
        '''
        req = ResourceCreateRequest()

        if resource is not None:
            req.resource.CopyFrom(
                plumbing.convert_resource_to_plumbing(resource))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Resources.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.resource = plumbing.convert_resource_to_porcelain(
            plumbing_response.resource)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Resource by ID.
        '''
        req = ResourceGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Resources.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.resource = plumbing.convert_resource_to_porcelain(
            plumbing_response.resource)
        return resp

    def update(self, resource, timeout=None):
        '''
         Update replaces all the fields of a Resource by ID.
        '''
        req = ResourceUpdateRequest()

        if resource is not None:
            req.resource.CopyFrom(
                plumbing.convert_resource_to_plumbing(resource))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Resources.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.resource = plumbing.convert_resource_to_porcelain(
            plumbing_response.resource)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a Resource by ID.
        '''
        req = ResourceDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Resources.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Resources matching a given set of criteria.
        '''
        req = ResourceListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'Resources.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.resources:
                    yield plumbing.convert_resource_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)

    def healthcheck(self, id, timeout=None):
        '''
         Healthcheck triggers a remote healthcheck. It may take minutes to propagate across a
         large network of Nodes. The call will return immediately, and the updated health of the
         Resource can be retrieved via Get or List.
        '''
        req = ResourceHealthcheckRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Healthcheck(
                    req,
                    metadata=self.parent.get_metadata('Resources.Healthcheck',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.ResourceHealthcheckResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp


class SnapshotResources:
    '''
    SnapshotResources exposes the read only methods of the Resources
    service for historical queries.
    '''
    def __init__(self, resources):
        self.resources = resources

    def get(self, id, timeout=None):
        '''
         Get reads one Resource by ID.
        '''
        return self.resources.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Resources matching a given set of criteria.
        '''
        return self.resources.list(filter, *args, timeout=timeout)


class ResourcesHistory:
    '''
     ResourcesHistory records all changes to the state of a Resource.
    See `strongdm.models.ResourceHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = ResourcesHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of ResourceHistory records matching a given set of criteria.
        '''
        req = ResourceHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'ResourcesHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_resource_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class RoleResources:
    '''
     RoleResources enumerates the resources to which roles have access.
     The RoleResources service is read-only.
    See `strongdm.models.RoleResource`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RoleResourcesStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RoleResource records matching a given set of criteria.
        '''
        req = RoleResourceListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RoleResources.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.role_resources:
                    yield plumbing.convert_role_resource_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotRoleResources:
    '''
    SnapshotRoleResources exposes the read only methods of the RoleResources
    service for historical queries.
    '''
    def __init__(self, role_resources):
        self.role_resources = role_resources

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RoleResource records matching a given set of criteria.
        '''
        return self.role_resources.list(filter, *args, timeout=timeout)


class RoleResourcesHistory:
    '''
     RoleResourcesHistory records all changes to the state of a RoleResource.
    See `strongdm.models.RoleResourceHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RoleResourcesHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RoleResourceHistory records matching a given set of criteria.
        '''
        req = RoleResourceHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RoleResourcesHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_role_resource_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Roles:
    '''
     A Role has a list of access rules which determine which Resources the members
     of the Role have access to. An Account can be a member of multiple Roles via
     AccountAttachments.
    See `strongdm.models.Role`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RolesStub(channel)

    def create(self, role, timeout=None):
        '''
         Create registers a new Role.
        '''
        req = RoleCreateRequest()

        if role is not None:
            req.role.CopyFrom(plumbing.convert_role_to_plumbing(role))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Roles.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.role = plumbing.convert_role_to_porcelain(plumbing_response.role)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one Role by ID.
        '''
        req = RoleGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Roles.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.role = plumbing.convert_role_to_porcelain(plumbing_response.role)
        return resp

    def update(self, role, timeout=None):
        '''
         Update replaces all the fields of a Role by ID.
        '''
        req = RoleUpdateRequest()

        if role is not None:
            req.role.CopyFrom(plumbing.convert_role_to_plumbing(role))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Roles.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.role = plumbing.convert_role_to_porcelain(plumbing_response.role)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a Role by ID.
        '''
        req = RoleDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Roles.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.RoleDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Roles matching a given set of criteria.
        '''
        req = RoleListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata('Roles.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.roles:
                    yield plumbing.convert_role_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotRoles:
    '''
    SnapshotRoles exposes the read only methods of the Roles
    service for historical queries.
    '''
    def __init__(self, roles):
        self.roles = roles

    def get(self, id, timeout=None):
        '''
         Get reads one Role by ID.
        '''
        return self.roles.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of Roles matching a given set of criteria.
        '''
        return self.roles.list(filter, *args, timeout=timeout)


class RolesHistory:
    '''
     RolesHistory records all changes to the state of a Role.
    See `strongdm.models.RoleHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = RolesHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of RoleHistory records matching a given set of criteria.
        '''
        req = RoleHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'RolesHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_role_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SecretStores:
    '''
     SecretStores are servers where resource secrets (passwords, keys) are stored.
    See:
    `strongdm.models.AWSStore`
    `strongdm.models.AzureStore`
    `strongdm.models.CyberarkConjurStore`
    `strongdm.models.CyberarkPAMStore`
    `strongdm.models.CyberarkPAMExperimentalStore`
    `strongdm.models.DelineaStore`
    `strongdm.models.GCPStore`
    `strongdm.models.VaultAppRoleStore`
    `strongdm.models.VaultTLSStore`
    `strongdm.models.VaultTokenStore`
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = SecretStoresStub(channel)

    def create(self, secret_store, timeout=None):
        req = SecretStoreCreateRequest()

        if secret_store is not None:
            req.secret_store.CopyFrom(
                plumbing.convert_secret_store_to_plumbing(secret_store))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Create',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreCreateResponse()
        resp.meta = plumbing.convert_create_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.secret_store = plumbing.convert_secret_store_to_porcelain(
            plumbing_response.secret_store)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one SecretStore by ID.
        '''
        req = SecretStoreGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.secret_store = plumbing.convert_secret_store_to_porcelain(
            plumbing_response.secret_store)
        return resp

    def update(self, secret_store, timeout=None):
        '''
         Update replaces all the fields of a SecretStore by ID.
        '''
        req = SecretStoreUpdateRequest()

        if secret_store is not None:
            req.secret_store.CopyFrom(
                plumbing.convert_secret_store_to_plumbing(secret_store))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Update',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreUpdateResponse()
        resp.meta = plumbing.convert_update_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.secret_store = plumbing.convert_secret_store_to_porcelain(
            plumbing_response.secret_store)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete removes a SecretStore by ID.
        '''
        req = SecretStoreDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('SecretStores.Delete',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.SecretStoreDeleteResponse()
        resp.meta = plumbing.convert_delete_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of SecretStores matching a given set of criteria.
        '''
        req = SecretStoreListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'SecretStores.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.secret_stores:
                    yield plumbing.convert_secret_store_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotSecretStores:
    '''
    SnapshotSecretStores exposes the read only methods of the SecretStores
    service for historical queries.
    '''
    def __init__(self, secret_stores):
        self.secret_stores = secret_stores

    def get(self, id, timeout=None):
        '''
         Get reads one SecretStore by ID.
        '''
        return self.secret_stores.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of SecretStores matching a given set of criteria.
        '''
        return self.secret_stores.list(filter, *args, timeout=timeout)


class SecretStoresHistory:
    '''
     SecretStoresHistory records all changes to the state of a SecretStore.
    See `strongdm.models.SecretStoreHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = SecretStoresHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of SecretStoreHistory records matching a given set of criteria.
        '''
        req = SecretStoreHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'SecretStoresHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_secret_store_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class WorkflowApprovers:
    '''
     WorkflowApprovers is an account or a role with the ability to approve requests bound to a workflow.
    See `strongdm.models.WorkflowApprover`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowApproversStub(channel)

    def create(self, workflow_approver, timeout=None):
        '''
         Create creates a new workflow approver
        '''
        req = WorkflowApproversCreateRequest()

        if workflow_approver is not None:
            req.workflow_approver.CopyFrom(
                plumbing.convert_workflow_approver_to_plumbing(
                    workflow_approver))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata(
                        'WorkflowApprovers.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowApproversCreateResponse()
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.workflow_approver = plumbing.convert_workflow_approver_to_porcelain(
            plumbing_response.workflow_approver)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one workflow approver by ID.
        '''
        req = WorkflowApproverGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('WorkflowApprovers.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowApproverGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.workflow_approver = plumbing.convert_workflow_approver_to_porcelain(
            plumbing_response.workflow_approver)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete deletes a workflow approver
        '''
        req = WorkflowApproversDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata(
                        'WorkflowApprovers.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowApproversDeleteResponse()
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflow approvers.
        '''
        req = WorkflowApproversListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'WorkflowApprovers.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.workflow_approvers:
                    yield plumbing.convert_workflow_approver_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotWorkflowApprovers:
    '''
    SnapshotWorkflowApprovers exposes the read only methods of the WorkflowApprovers
    service for historical queries.
    '''
    def __init__(self, workflow_approvers):
        self.workflow_approvers = workflow_approvers

    def get(self, id, timeout=None):
        '''
         Get reads one workflow approver by ID.
        '''
        return self.workflow_approvers.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflow approvers.
        '''
        return self.workflow_approvers.list(filter, *args, timeout=timeout)


class WorkflowApproversHistory:
    '''
     WorkflowApproversHistory provides records of all changes to the state of a WorkflowApprover.
    See `strongdm.models.WorkflowApproverHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowApproversHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of WorkflowApproversHistory records matching a given set of criteria.
        '''
        req = WorkflowApproversHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'WorkflowApproversHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_workflow_approver_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class WorkflowAssignments:
    '''
     WorkflowAssignments links a Resource to a Workflow. The assigned resources are those that a user can request
     access to via the workflow.
    See `strongdm.models.WorkflowAssignment`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowAssignmentsStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflow assignments.
        '''
        req = WorkflowAssignmentsListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'WorkflowAssignments.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.workflow_assignments:
                    yield plumbing.convert_workflow_assignment_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotWorkflowAssignments:
    '''
    SnapshotWorkflowAssignments exposes the read only methods of the WorkflowAssignments
    service for historical queries.
    '''
    def __init__(self, workflow_assignments):
        self.workflow_assignments = workflow_assignments

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflow assignments.
        '''
        return self.workflow_assignments.list(filter, *args, timeout=timeout)


class WorkflowAssignmentsHistory:
    '''
     WorkflowAssignmentsHistory provides records of all changes to the state of a WorkflowAssignment.
    See `strongdm.models.WorkflowAssignmentHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowAssignmentsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of WorkflowAssignmentsHistory records matching a given set of criteria.
        '''
        req = WorkflowAssignmentsHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'WorkflowAssignmentsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_workflow_assignment_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class WorkflowRoles:
    '''
     WorkflowRole links a role to a workflow. The linked roles indicate which roles a user must be a part of
     to request access to a resource via the workflow.
    See `strongdm.models.WorkflowRole`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowRolesStub(channel)

    def create(self, workflow_role, timeout=None):
        '''
         Create creates a new workflow role
        '''
        req = WorkflowRolesCreateRequest()

        if workflow_role is not None:
            req.workflow_role.CopyFrom(
                plumbing.convert_workflow_role_to_plumbing(workflow_role))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('WorkflowRoles.Create',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowRolesCreateResponse()
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.workflow_role = plumbing.convert_workflow_role_to_porcelain(
            plumbing_response.workflow_role)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one workflow role by ID.
        '''
        req = WorkflowRoleGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('WorkflowRoles.Get',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowRoleGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.workflow_role = plumbing.convert_workflow_role_to_porcelain(
            plumbing_response.workflow_role)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete deletes a workflow role
        '''
        req = WorkflowRolesDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('WorkflowRoles.Delete',
                                                      req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowRolesDeleteResponse()
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflow roles.
        '''
        req = WorkflowRolesListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'WorkflowRoles.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.workflow_role:
                    yield plumbing.convert_workflow_role_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotWorkflowRoles:
    '''
    SnapshotWorkflowRoles exposes the read only methods of the WorkflowRoles
    service for historical queries.
    '''
    def __init__(self, workflow_roles):
        self.workflow_roles = workflow_roles

    def get(self, id, timeout=None):
        '''
         Get reads one workflow role by ID.
        '''
        return self.workflow_roles.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflow roles.
        '''
        return self.workflow_roles.list(filter, *args, timeout=timeout)


class WorkflowRolesHistory:
    '''
     WorkflowRolesHistory provides records of all changes to the state of a WorkflowRole
    See `strongdm.models.WorkflowRoleHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowRolesHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of WorkflowRolesHistory records matching a given set of criteria.
        '''
        req = WorkflowRolesHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'WorkflowRolesHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_workflow_role_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class Workflows:
    '''
     Workflows are the collection of rules that define the resources to which access can be requested,
     the users that can request that access, and the mechanism for approving those requests which can either
     be automatic approval or a set of users authorized to approve the requests.
    See `strongdm.models.Workflow`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowsStub(channel)

    def create(self, workflow, timeout=None):
        '''
         Create creates a new workflow and requires a name for the workflow.
        '''
        req = WorkflowCreateRequest()

        if workflow is not None:
            req.workflow.CopyFrom(
                plumbing.convert_workflow_to_plumbing(workflow))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Create(
                    req,
                    metadata=self.parent.get_metadata('Workflows.Create', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowCreateResponse()
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.workflow = plumbing.convert_workflow_to_porcelain(
            plumbing_response.workflow)
        return resp

    def get(self, id, timeout=None):
        '''
         Get reads one workflow by ID.
        '''
        req = WorkflowGetRequest()
        if self.parent.snapshot_datetime is not None:
            req.meta.CopyFrom(GetRequestMetadata())
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Get(
                    req,
                    metadata=self.parent.get_metadata('Workflows.Get', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowGetResponse()
        resp.meta = plumbing.convert_get_response_metadata_to_porcelain(
            plumbing_response.meta)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.workflow = plumbing.convert_workflow_to_porcelain(
            plumbing_response.workflow)
        return resp

    def delete(self, id, timeout=None):
        '''
         Delete deletes an existing workflow.
        '''
        req = WorkflowDeleteRequest()

        req.id = (id)
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Delete(
                    req,
                    metadata=self.parent.get_metadata('Workflows.Delete', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowDeleteResponse()
        resp.id = (plumbing_response.id)
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        return resp

    def update(self, workflow, timeout=None):
        '''
         Update updates an existing workflow.
        '''
        req = WorkflowUpdateRequest()

        if workflow is not None:
            req.workflow.CopyFrom(
                plumbing.convert_workflow_to_plumbing(workflow))
        tries = 0
        plumbing_response = None
        while True:
            try:
                plumbing_response = self.stub.Update(
                    req,
                    metadata=self.parent.get_metadata('Workflows.Update', req),
                    timeout=timeout)
            except Exception as e:
                if self.parent.shouldRetry(tries, e):
                    tries += 1
                    self.parent.jitterSleep(tries)
                    continue
                raise plumbing.convert_error_to_porcelain(e) from e
            break

        resp = models.WorkflowUpdateResponse()
        resp.rate_limit = plumbing.convert_rate_limit_metadata_to_porcelain(
            plumbing_response.rate_limit)
        resp.workflow = plumbing.convert_workflow_to_porcelain(
            plumbing_response.workflow)
        return resp

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflows.
        '''
        req = WorkflowListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'Workflows.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.workflows:
                    yield plumbing.convert_workflow_to_porcelain(plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)


class SnapshotWorkflows:
    '''
    SnapshotWorkflows exposes the read only methods of the Workflows
    service for historical queries.
    '''
    def __init__(self, workflows):
        self.workflows = workflows

    def get(self, id, timeout=None):
        '''
         Get reads one workflow by ID.
        '''
        return self.workflows.get(id, timeout=timeout)

    def list(self, filter, *args, timeout=None):
        '''
         Lists existing workflows.
        '''
        return self.workflows.list(filter, *args, timeout=timeout)


class WorkflowsHistory:
    '''
     WorkflowsHistory provides records of all changes to the state of a Workflow.
    See `strongdm.models.WorkflowHistory`.
    '''
    def __init__(self, channel, client):
        self.parent = client
        self.stub = WorkflowsHistoryStub(channel)

    def list(self, filter, *args, timeout=None):
        '''
         List gets a list of WorkflowHistory records matching a given set of criteria.
        '''
        req = WorkflowHistoryListRequest()
        req.meta.CopyFrom(ListRequestMetadata())
        if self.parent.page_limit > 0:
            req.meta.limit = self.parent.page_limit
        if self.parent.snapshot_datetime is not None:
            req.meta.snapshot_at.FromDatetime(self.parent.snapshot_datetime)

        req.filter = plumbing.quote_filter_args(filter, *args)

        def generator(svc, req):
            tries = 0
            while True:
                try:
                    plumbing_response = svc.stub.List(
                        req,
                        metadata=svc.parent.get_metadata(
                            'WorkflowsHistory.List', req),
                        timeout=timeout)
                except Exception as e:
                    if self.parent.shouldRetry(tries, e):
                        tries += 1
                        self.parent.jitterSleep(tries)
                        continue
                    raise plumbing.convert_error_to_porcelain(e) from e
                tries = 0
                for plumbing_item in plumbing_response.history:
                    yield plumbing.convert_workflow_history_to_porcelain(
                        plumbing_item)
                if plumbing_response.meta.next_cursor == '':
                    break
                req.meta.cursor = plumbing_response.meta.next_cursor

        return generator(self, req)
