# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .job_input import JobInput


class JobInputs(JobInput):
    """Describes a list of of inputs to a Job.

    All required parameters must be populated in order to send to Azure.

    :param label: A label that is assigned to a JobInput, that is used to
     satisfy a reference used in the Transform. For example, a Transform can be
     authored so as to take an image file with the label 'xyz' and apply it as
     an overlay onto the input video before it is encoded. When submitting a
     Job, exactly one of the JobInputs should be the image file, and it should
     have the label 'xyz'.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param inputs: List of inputs to a Job.
    :type inputs: list[~azure.mgmt.media.models.JobInput]
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[JobInput]'},
    }

    def __init__(self, *, label: str=None, inputs=None, **kwargs) -> None:
        super(JobInputs, self).__init__(label=label, **kwargs)
        self.inputs = inputs
        self.odatatype = '#Microsoft.Media.JobInputs'
