# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobInput(Model):
    """Base class for inputs to a Job.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JobInputClip, JobInputs

    All required parameters must be populated in order to send to Azure.

    :param label: A label that is assigned to a JobInput, that is used to
     satisfy a reference used in the Transform. For example, a Transform can be
     authored so as to take an image file with the label 'xyz' and apply it as
     an overlay onto the input video before it is encoded. When submitting a
     Job, exactly one of the JobInputs should be the image file, and it should
     have the label 'xyz'.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odatatype': {'#Microsoft.Media.JobInputClip': 'JobInputClip', '#Microsoft.Media.JobInputs': 'JobInputs'}
    }

    def __init__(self, **kwargs):
        super(JobInput, self).__init__(**kwargs)
        self.label = kwargs.get('label', None)
        self.odatatype = None
